﻿using Edu.CacheManager.Base;
using Edu.Model.CacheModel;
using Edu.Repository.User;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Edu.Cache.User
{
    /// <summary>
    /// redis缓存
    /// </summary>
    public class UserReidsCache
    {
        /// <summary>
        /// 使用redis第几号库
        /// </summary>
        public static readonly int REDIS_DB3 = 3;

        static readonly RedisHelper redis = new RedisHelper(REDIS_DB3);

        /// <summary>
        /// 设置缓存
        /// </summary>
        /// <param name="model"></param>
        public static void UserInfoSet(string cacheKey, UserInfo model, int JwtExpirTime)
        {
            try
            {
                TimeSpan ts = GetExpirTime(JwtExpirTime);
                redis.StringSet<UserInfo>(cacheKey, model, ts);
            }
            catch (Exception ex)
            {
                Common.Plugin.LogHelper.Write(ex, "UserInfoSet缓存设置失败");
            }
        }

        /// <summary>
        /// 获取缓存时长
        /// </summary>
        /// <param name="JwtExpirTime"></param>
        /// <returns></returns>
        private static TimeSpan GetExpirTime(int JwtExpirTime)
        {
            DateTime dt = DateTime.Now;
            DateTime dt2 = DateTime.Now;
            TimeSpan ts = dt.AddSeconds(JwtExpirTime) - dt2;
            return ts;
        }

        /// <summary>
        /// 判断key是否存在
        /// </summary>
        /// <param name="cacheKey"></param>
        /// <returns></returns>
        public static bool Exists(string cacheKey)
        {
            return redis.KeyExists(cacheKey);
        }

        /// <summary>
        /// 设置缓存
        /// </summary>
        /// <param name="cacheKey"></param>
        /// <param name="Data"></param>
        /// <param name="JwtExpirTime"></param>
        public static void Set(string cacheKey, object Data, int JwtExpirTime)
        {
            try
            {
                TimeSpan ts = GetExpirTime(JwtExpirTime);
                redis.StringSet(cacheKey, Data, ts);
            }
            catch (Exception)
            {
            }
        }

        /// <summary>
        /// 账号仓储层对象
        /// </summary>
        private static readonly RB_AccountRepository accountRepository = new RB_AccountRepository();

        /// <summary>
        /// 获取用户登录信息
        /// </summary>
        /// <param name="Id">账号Id</param>
        /// <returns></returns>
        public static UserInfo GetUserLoginInfo(object Id)
        {

            UserInfo userInfo = null;
            if (Id != null)
            {
                string cacheKey = Cache.CacheKey.User_Login_Key + Id.ToString();
                try
                {
                    userInfo = redis.StringGet<UserInfo>(cacheKey);
                }
                catch (Exception ex)
                {
                   Common.Plugin.LogHelper.Write(ex, "GetUserLoginInfo");
                }
                if (userInfo == null)
                {
                    Int32.TryParse(Id.ToString(), out int NewId);
                    if (NewId > 0)
                    {
                        string token = "";
                        var model = accountRepository.GetAccountListExtRepository(new Model.ViewModel.User.RB_Account_ViewModel()
                        {
                            Id = NewId
                        })?.FirstOrDefault();
                        if (model != null)
                        {
                            userInfo = new UserInfo
                            {
                                Id = model.Id,
                                Group_Id = model.Group_Id,
                                School_Id = model.School_Id,
                                AccountName = model.AccountName,
                                GroupName = model.GroupName,
                                SchoolName = model.SchoolName,
                                Token = token,
                            };
                            UserInfoSet(Cache.CacheKey.User_Login_Key + Id.ToString(), userInfo, Common.Config.JwtExpirTime);
                        }
                    }
                }
            }
            else
            {
                userInfo = new UserInfo();
            }
            return userInfo;
        }
    }
}