﻿using System;

namespace Edu.Common.API
{
    /// <summary>
    /// Api返回结果
    /// </summary>
    public class ApiResult
    {
        /// <summary>
        /// 状态码
        /// </summary>
        public int Code { get; set; }

        /// <summary>
        /// 提示信息
        /// </summary>
        public string Message { get; set; }


        /// <summary>
        /// 返回数据
        /// </summary>
        public object Data { get; set; }

        /// <summary>
        /// 请求成功
        /// </summary>
        /// <param name="message">提示信息</param>
        /// <param name="data">返回数据</param>
        /// <returns></returns>
        public static ApiResult Success(string message = null, object data = null)
        {
            return new ApiResult() { Code = (int)ResultCode.Success, Message = message ?? "操作成功！", Data = data };
        }

        /// <summary>
        /// 请求失败
        /// </summary>
        /// <param name="message">提示信息</param>
        /// <param name="data">返回数据</param>
        /// <returns></returns>
        public static ApiResult Failed(string message = null, object data = null)
        {
            return new ApiResult { Code = (int)ResultCode.Fail, Message = message ?? "操作失败！", Data = data };
        }

        /// <summary>
        /// 服务器返回提示信息，询问用户是否确认操作(事例:已经存在此领队/导游的档期数据，是否继续保存数据?)
        /// </summary>
        /// <param name="message"></param>
        /// <param name="data"></param>
        /// <returns></returns>
        public static ApiResult Tip(string message = null, object data = null)
        {
            return new ApiResult { Code = (int)ResultCode.Tip, Message = message ?? "", Data = data };
        }

        /// <summary>
        /// 参数丢失
        /// </summary>
        /// <param name="message"></param>
        /// <param name="data"></param>
        /// <returns></returns>
        public static ApiResult ParamIsNull(string message = null, object data = null)
        {
            return new ApiResult { Code = (int)ResultCode.ParamIsNull, Message = message ?? "参数为空！", Data = data };
        }
    }

    /// <summary>
    /// 分页返回数据
    /// </summary>
    public class ResultPageModel
    {
        /// <summary>
        /// 当前页
        /// </summary>
        public int PageIndex { get; set; }

        /// <summary>
        /// 分页大小
        /// </summary>
        public int PageSize { get; set; }

        /// <summary>
        /// 总条数
        /// </summary>
        public long Count { get; set; }

        /// <summary>
        /// 分页数
        /// </summary>
        public int PageCount
        {
            get
            {
                if (PageSize != 0 && Count != 0)
                {
                    if (Count % PageSize == 0)
                    {
                        return Convert.ToInt32(Count) / PageSize;
                    }
                    else
                    {
                        return Convert.ToInt32(Count) / PageSize + 1;
                    }
                }
                else
                {
                    return 0;
                }

            }
        }

        /// <summary>
        /// 分页数据
        /// </summary>
        public object PageData { get; set; }
    }
}