﻿using Edu.Common.Enum;
using System;
using VT.FW.DB;

namespace Edu.Model.Entity.Course
{
    /// <summary>
    /// 课程讨论实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Course_Discuss
    {
		/// <summary>
		/// 主键（话题Id）
		/// </summary>
		public int DiscussId { get; set; }

		/// <summary>
		/// 课程编号
		/// </summary>
		public int CourseId { get; set; }

		/// <summary>
		/// 话题标题
		/// </summary>
		public string DiscussTitle { get; set; }

		/// <summary>
		/// 话题内容
		/// </summary>
		public string DiscussContent { get; set; }

		/// <summary>
		/// 话题附件
		/// </summary>
		public string DiscussUrl { get; set; }

		/// <summary>
		/// 创建人
		/// </summary>
		public int CreateBy { get; set; }

		/// <summary>
		/// 创建时间
		/// </summary>
		public DateTime CreateTime { get; set; }

		/// <summary>
		/// 修改人
		/// </summary>
		public int UpdateBy { get; set; }

		/// <summary>
		/// 更新时间
		/// </summary>
		public DateTime UpdateTime { get; set; }

		/// <summary>
		/// 学校编号
		/// </summary>
		public int School_Id { get; set; }

		/// <summary>
		/// 集团编号
		/// </summary>
		public int Group_Id { get; set; }

		/// <summary>
		/// 删除状态
		/// </summary>
		public DateStateEnum Status { get; set; }
	}
}