﻿using System;
using VT.FW.DB;

namespace Edu.Model.Entity.Course
{
    /// <summary>
    /// 课程作业实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Course_Job
    {
		/// <summary>
		/// 主键（作业Id）
		/// </summary>
		public int JobId { get; set; }

		/// <summary>
		/// 课程编号
		/// </summary>
		public int CourseId { get; set; }

		/// <summary>
		/// 作业名称
		/// </summary>
		public string JobName { get; set; }

		/// <summary>
		/// 评分机制(1-百分制，2-自定义)
		/// </summary>
		public int ScoreType { get; set; }

		/// <summary>
		/// 题型设置(1-按题型归类，2-不按题型归类)
		/// </summary>
		public int TopicType { get; set; }

		/// <summary>
		/// 创建人
		/// </summary>
		public int CreateBy { get; set; }

		/// <summary>
		/// 创建时间
		/// </summary>
		public DateTime CreateTime { get; set; }

		/// <summary>
		/// 修改人
		/// </summary>
		public int UpdateBy { get; set; }

		/// <summary>
		/// 更新时间
		/// </summary>
		public DateTime UpdateTime { get; set; }

		/// <summary>
		/// 接收对象(班级)
		/// </summary>
		public string ReciveClass { get; set; }

		/// <summary>
		/// 作业开始时间
		/// </summary>
		public DateTime? StartTime { get; set; }

		/// <summary>
		/// 作业结束时间
		/// </summary>
		public DateTime? EndTime { get; set; }

		/// <summary>
		/// 是否允许学生补交(1-允许)
		/// </summary>
		public int IsAllowDelay { get; set; }

		/// <summary>
		/// 及格标准分数
		/// </summary>
		public int PassBasicScore { get; set; }

		/// <summary>
		/// 是否允许重做(1-允许)
		/// </summary>
		public int IsAgain { get; set; }

		/// <summary>
		/// 重做次数
		/// </summary>
		public int AgainTimes { get; set; }

		/// <summary>
		/// 是否多次作答取历史最高成绩(1-是)
		/// </summary>
		public int IsGetHighScore { get; set; }

		/// <summary>
		/// 是否允许查看答案(1-允许)
		/// </summary>
		public int IsLookAnswer { get; set; }

		/// <summary>
		/// 查看答案类型（1-教师批阅后,2-提交后，3-作业结束后）
		/// </summary>
		public int LookAnswerType { get; set; }

		/// <summary>
		/// 是否允许查看分数（1-允许）
		/// </summary>
		public int IsLookScore { get; set; }

		/// <summary>
		/// 是否允许查看题型分数(1-允许)
		/// </summary>
		public int IsLookQTypeScore { get; set; }

		/// <summary>
		/// 是否允许学生粘贴答案(1-允许)
		/// </summary>
		public int IsPaste { get; set; }

		/// <summary>
		/// 学生重做时显示对错（1-显示）
		/// </summary>
		public int IsAgainShowTrueFalse { get; set; }

		/// <summary>
		/// 题目乱序（1-是）
		/// </summary>
		public int IsOutOrder { get; set; }

		/// <summary>
		/// 是否随机出题（1-是）
		/// </summary>
		public int IsRandom { get; set; }

		/// <summary>
		/// 随机出题数量
		/// </summary>
		public int RandomNum { get; set; }

		/// <summary>
		/// 是否发送通知（1-发送）
		/// </summary>
		public int IsSendMsg { get; set; }

		/// <summary>
		/// 提前多少小时发送
		/// </summary>
		public int SendMsgHour { get; set; }

		/// <summary>
		/// 是否允许做作业（1-允许）
		/// </summary>
		public int IsWork { get; set; }

		/// <summary>
		/// 完成多少可以做作业
		/// </summary>
		public int WorkProcess { get; set; }

		/// <summary>
		/// 填空类型的题目设为主观题(1-是）
		/// </summary>
		public int IsBlankobj { get; set; }

		/// <summary>
		/// 填空题答案不区分大小写(1-是)
		/// </summary>
		public int IsCompletionIngoreCase { get; set; }

		/// <summary>
		/// 填空题答案忽略符号(1-是)
		/// </summary>
		public int IsBlankIgnoreComma { get; set; }

		/// <summary>
		/// 多选题未选全给一半分(1-是)
		/// </summary>
		public int IsMultiHalfScore { get; set; }
	}
}