﻿using System;
using VT.FW.DB;

namespace Edu.Model.Entity.Course
{
    /// <summary>
    /// 课程配置实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Course_Setting
    {
		/// <summary>
		/// 主键(配置编号)
		/// </summary>
		public int SettingId { get; set; }

		/// <summary>
		/// App端是否支持缓存(1-支持)
		/// </summary>
		public int AppIsCache { get; set; }

		/// <summary>
		/// 播放类型(1-继续播放下一课时，2-暂停本课时，3-循环播放本课时)
		/// </summary>
		public int PlayType { get; set; }

		/// <summary>
		/// 学校Id
		/// </summary>
		public int School_Id { get; set; }

		/// <summary>
		/// 集团编号
		/// </summary>
		public int Group_Id { get; set; }

		/// <summary>
		/// 创建人
		/// </summary>
		public int CreateBy { get; set; }

		/// <summary>
		/// 创建时间
		/// </summary>
		public DateTime CreateTime { get; set; }

		/// <summary>
		/// 修改人
		/// </summary>
		public int UpdateBy { get; set; }

		/// <summary>
		/// 更新时间
		/// </summary>
		public DateTime UpdateTime { get; set; }
	}
}
