﻿using Edu.Common.Enum;
using System;
using VT.FW.DB;

namespace Edu.Model.Entity.Course
{
    /// <summary>
    /// 课程教案实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Course_TeachPlan
    {
		/// <summary>
		/// 主键（教案编号）
		/// </summary>
		public int PlanId { get; set; }

		/// <summary>
		/// 课程编号
		/// </summary>
		public int CourseId { get; set; }

		/// <summary>
		/// 教案名称
		/// </summary>
		public string PlanName { get; set; }

		/// <summary>
		/// 课前
		/// </summary>
		public string ClassBefore { get; set; }

		/// <summary>
		/// 课中
		/// </summary>
		public string ClassIn { get; set; }

		/// <summary>
		/// 课后
		/// </summary>
		public string ClassAfter { get; set; }

		/// <summary>
		/// 父节点编号
		/// </summary>
		public int ParentPlanId { get; set; }

		/// <summary>
		/// 文件路径
		/// </summary>
		public string SourceUrl { get; set; }

		/// <summary>
		/// 文件后缀名
		/// </summary>
		public string PlanFileExtension { get; set; }

		/// <summary>
		/// 创建人
		/// </summary>
		public int CreateBy { get; set; }

		/// <summary>
		/// 创建时间
		/// </summary>
		public DateTime CreateTime { get; set; }

		/// <summary>
		/// 修改人
		/// </summary>
		public int UpdateBy { get; set; }

		/// <summary>
		/// 更新时间
		/// </summary>
		public DateTime UpdateTime { get; set; }

		/// <summary>
		/// 节点类型(0-文件，1-文件夹)
		/// </summary>
		public int PlanNodeType { get; set; }

		/// <summary>
		/// 是否置顶(1-是)
		/// </summary>
		public int IsTop { get; set; }

		/// <summary>
		/// 上传生成文件路径
		/// </summary>
		public string ExtUrl { get; set; }

		/// <summary>
		/// 备注
		/// </summary>
		public string Remark { get; set; }

		/// <summary>
		/// 学校Id
		/// </summary>
		public int School_Id { get; set; }

		/// <summary>
		/// 集团编号
		/// </summary>
		public int Group_Id { get; set; }

		/// <summary>
		/// 删除状态
		/// </summary>
		public DateStateEnum Status { get; set; }
	}
}