﻿using Edu.Common.Enum;
using Edu.Common.Enum.Question;
using System;
using VT.FW.DB;

namespace Edu.Model.Entity.Question
{
    /// <summary>
    /// 题库实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Question
    {
		/// <summary>
		/// 主键(问题编号)
		/// </summary>
		public int QuestionId { get; set; }

		/// <summary>
		/// 课程编号
		/// </summary>
		public int CourseId { get; set; }

		/// <summary>
		/// 问题名称
		/// </summary>
		public string Title { get; set; }

		/// <summary>
		/// 难易程度(1-易，2-中，3-难)
		/// </summary>
		public DifficultyTypeEnum DifficultyType { get; set; }

		/// <summary>
		/// 答案解析
		/// </summary>
		public string AnswerParse { get; set; }

		/// <summary>
		/// 问题类型编号
		/// </summary>
		public int QuestionTypeId { get; set; }

		/// <summary>
		/// 知识点
		/// </summary>
		public string Knowledge { get; set; }

		/// <summary>
		/// 创建人
		/// </summary>
		public int CreateBy { get; set; }

		/// <summary>
		/// 创建时间
		/// </summary>
		public DateTime CreateTime { get; set; }

		/// <summary>
		/// 修改人
		/// </summary>
		public int UpdateBy { get; set; }

		/// <summary>
		/// 更新时间
		/// </summary>
		public DateTime UpdateTime { get; set; }

		/// <summary>
		/// 是否同步修改引用此题目的作业和考试(1-是)
		/// </summary>
		public int IsUpdateJobExam { get; set; }

		/// <summary>
		/// 删除状态
		/// </summary>
		public DateStateEnum Status { get; set; }

		/// <summary>
		/// 排序
		/// </summary>
		public int SortNum { get; set; }

		/// <summary>
		/// 问题答案【JSON字符串】
		/// </summary>
		public string Answer { get; set; }

		/// <summary>
		/// 问题分数
		/// </summary>
		public decimal Score { get; set; }
	}
}
