﻿using Edu.Common.Enum;
using System;
using VT.FW.DB;

namespace Edu.Model.Entity.Question
{
    /// <summary>
    /// 题目知识点实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Question_Point
    {
		/// <summary>
		/// 主键（知识点编号）
		/// </summary>
		public int PointId { get; set; }

		/// <summary>
		/// 问题编号
		/// </summary>
		public int QuestionId { get; set; }

		/// <summary>
		/// 课程编号
		/// </summary>
		public int CourseId { get; set; }

		/// <summary>
		/// 知识点名称
		/// </summary>
		public string PointName { get; set; }

		/// <summary>
		/// 创建人
		/// </summary>
		public int CreateBy { get; set; }

		/// <summary>
		/// 创建时间
		/// </summary>
		public DateTime CreateTime { get; set; }

		/// <summary>
		/// 修改人
		/// </summary>
		public int UpdateBy { get; set; }

		/// <summary>
		/// 更新时间
		/// </summary>
		public DateTime UpdateTime { get; set; }

		/// <summary>
		/// 删除状态
		/// </summary>
		public DateStateEnum Status { get; set; }
	}
}