﻿using Edu.Common.Enum;
using System;
using VT.FW.DB;

namespace Edu.Model.Entity.Question
{
    /// <summary>
    /// 题目类型实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Question_Type
    {
		/// <summary>
		/// 主键（题目类型主键编号）
		/// </summary>
		public int QId { get; set; }

		/// <summary>
		/// 题目类型Key
		/// </summary>
		public string Key { get; set; }

		/// <summary>
		/// 题目类型名称
		/// </summary>
		public string Name { get; set; }

		/// <summary>
		/// 题目类型图标
		/// </summary>
		public string Icon { get; set; }

		/// <summary>
		/// 删除状态
		/// </summary>
		public DateStateEnum Status { get; set; }
	}
}
