﻿using Edu.Common.Enum;
using System;
using VT.FW.DB;

namespace Edu.Model.Entity.System
{
    /// <summary>
    /// 系统菜单实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Menu
    {
		/// <summary>
		/// 主键(菜单编号)
		/// </summary>
		public int MenuId { get; set; }

		/// <summary>
		/// 父节点Id
		/// </summary>
		public int ParentId { get; set; }

		/// <summary>
		/// 菜单名称
		/// </summary>
		public string MenuName { get; set; }

		/// <summary>
		/// 菜单链接地址
		/// </summary>
		public string MenuUrl { get; set; }

		/// <summary>
		/// 菜单图标
		/// </summary>
		public string MenuIcon { get; set; }

		/// <summary>
		/// 菜单等级
		/// </summary>
		public int MenuLevel { get; set; }

		/// <summary>
		/// 菜单类型(1-管理端,2-教师端,3-助教端,4-学生端)
		/// </summary>
		public int MenuType { get; set; }

		/// <summary>
		/// 排序
		/// </summary>
		public int SortNum { get; set; }

		/// <summary>
		/// 创建时间
		/// </summary>
		public DateTime CreateTime { get; set; }

		/// <summary>
		/// 删除状态
		/// </summary>
		public DateStateEnum Status { get; set; }
	}
}
