﻿using Edu.Common.Enum;
using Edu.Common.Enum.User;
using System;
using VT.FW.DB;

namespace Edu.Model.Entity.User
{
    /// <summary>
    /// 用户账号实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Account
    {
		/// <summary>
		/// 主键(账号编号)
		/// </summary>
		public int Id { get; set; }

		/// <summary>
		/// 账号
		/// </summary>
		public string Account { get; set; }

		/// <summary>
		/// 密码
		/// </summary>
		public string Password { get; set; }

		/// <summary>
		/// 账号类型(1-管理端，2,-教师端，3-助教，4-学生)
		/// </summary>
		public AccountTypeEnum AccountType { get; set; }

		/// <summary>
		/// 关联Id【1-关联rb_manager(MId),2-关联rb_teacher(TId)，3-关联rb_assist(AId)，4-关联rb_student(StuId)】
		/// </summary>
		public int AccountId { get; set; }

		/// <summary>
		/// 创建人
		/// </summary>
		public int CreateBy { get; set; }

		/// <summary>
		/// 创建时间
		/// </summary>
		public DateTime CreateTime { get; set; }

		/// <summary>
		/// 修改人
		/// </summary>
		public int UpdateBy { get; set; }

		/// <summary>
		/// 修改时间
		/// </summary>
		public DateTime UpdateTime { get; set; }

		/// <summary>
		/// 集团编号
		/// </summary>
		public int Group_Id { get; set; }

		/// <summary>
		/// 学校编号
		/// </summary>
		public int School_Id { get; set; }

		/// <summary>
		/// 删除状态
		/// </summary>
		public DateStateEnum Status { get; set; }
	}
}
