﻿using Edu.Common.Enum;
using System;
using VT.FW.DB;

namespace Edu.Model.Entity.User
{
    /// <summary>
    /// 学校实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_School
    {
        /// <summary>
        /// 主键(学校编号)
        /// </summary>
        public int SId { get; set; }

        /// <summary>
        /// 学校名称
        /// </summary>
        public string SName { get; set; }

        /// <summary>
        /// 学校地址
        /// </summary>
        public string SAddress { get; set; }

        /// <summary>
        /// 联系人
        /// </summary>
        public string SLinkMan { get; set; }

        /// <summary>
        /// 联系电话
        /// </summary>
        public string SLinkTel { get; set; }

        /// <summary>
        /// 学校域名
        /// </summary>
        public string SDomain { get; set; }

        /// <summary>
        /// 学校Logo
        /// </summary>
        public string SLogo { get; set; }

        /// <summary>
        ///备注
        /// </summary>
        public string Remark { get; set; }

        /// <summary>
        /// 删除状态(0-正常,1-删除)
        /// </summary>
        public DateStateEnum Status { get; set; }

        /// <summary>
        /// 集团编号
        /// </summary>
        public int Group_Id { get; set; }

        /// <summary>
        /// 创建人
        /// </summary>
        public int CreateBy { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreateTime { get; set; }

        /// <summary>
        /// 更新人
        /// </summary>
        public int UpdateBy { get; set; }

        /// <summary>
        /// 更新时间
        /// </summary>
        public DateTime UpdateTime { get; set; }
    }
}