﻿using Edu.Common;
using Edu.Common.Plugin;
using System;

namespace Edu.Model.ViewModel.User
{
    /// <summary>
    /// 教师视图实体类
    /// </summary>
    [Serializable]
    public class RB_Teacher_ViewModel : Model.Entity.User.RB_Teacher
    {
        /// <summary>
        /// 集团名称
        /// </summary>
        public string GroupName { get; set; }

        /// <summary>
        /// 学校名称
        /// </summary>
        public string SName { get; set; }

        /// <summary>
        /// 创建人
        /// </summary>
        public string CreateByName { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public string CreateTimeStr { get { return this.CreateTime.FormatTime(); } }

        /// <summary>
        /// 修改人
        /// </summary>
        public string UpdateByName { get; set; }

        /// <summary>
        /// 修改时间
        /// </summary>
        public string UpdateTimeStr { get { return this.UpdateTime.FormatTime(); } }

        /// <summary>
        /// 审核状态字符串
        /// </summary>
        public string AuditStatusStr { get { return this.AuditStatus.ToName(); } }

        /// <summary>
        /// 课程数量
        /// </summary>
        public int CourseCount { get; set; }

        /// <summary>
        /// 网课产品
        /// </summary>
        public int OnlineClassCount { get; set; }

        /// <summary>
        /// 网课订单
        /// </summary>
        public int OnlineOrderCount { get; set; }
    }
}