﻿using Edu.Common.Enum;
using Edu.Model.ViewModel.Course;
using Edu.Repository.Course;
using System.Collections.Generic;
using VT.FW.DB;

namespace Edu.Module.Course
{
    /// <summary>
    /// 课程处理类
    /// </summary>
    public class CourseModule
    {
        /// <summary>
        /// 课程章节仓储层对象
        /// </summary>
        private readonly RB_Course_ChapterRepository chapterRepository = new RB_Course_ChapterRepository();

        /// <summary>
        /// 课程讨论仓储层对象
        /// </summary>
        private readonly RB_Course_DiscussRepository discussRepository = new RB_Course_DiscussRepository();

        /// <summary>
        /// 课程通知仓储层对象
        /// </summary>
        private readonly RB_Course_NoticeRepository noticeRepository = new RB_Course_NoticeRepository();

        /// <summary>
        /// 课程通知接收仓储层对象
        /// </summary>
        private readonly RB_Course_NoticeReviceRepository noticeReviceRepository = new RB_Course_NoticeReviceRepository();

        /// <summary>
        /// 课程设置仓储层对象
        /// </summary>
        private readonly RB_Course_SettingRepository settingRepository = new RB_Course_SettingRepository();

        /// <summary>
        /// 课程资料仓储层对象
        /// </summary>
        private readonly RB_Course_SourceRepository sourceRepository = new RB_Course_SourceRepository();

        /// <summary>
        /// 课程教案仓储层对象
        /// </summary>
        private readonly RB_Course_TeachPlanRepository teachPlanRepository = new RB_Course_TeachPlanRepository();

        /// <summary>
        /// 课程处理仓储层对象
        /// </summary>
        private readonly RB_CourseRepository courseRepository = new RB_CourseRepository();

        /// <summary>
        /// 课程作业仓储层对象
        /// </summary>
        private readonly RB_Course_JobRepository courseJobRepository = new RB_Course_JobRepository();

        #region 课程管理

        /// <summary>
        /// 获取课程列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course_ViewModel> GetCourseListModule(RB_Course_ViewModel query)
        {
            return courseRepository.GetCourseListRepository(query);
        }

        /// <summary>
        /// 获取课程分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course_ViewModel> GetCoursePageListModule(int pageIndex, int pageSize, out long rowsCount, RB_Course_ViewModel query)
        {
            return courseRepository.GetCoursePageListRepository(pageIndex, pageSize, out rowsCount, query);
        }

        /// <summary>
        /// 根据课程编号获取课程实体
        /// </summary>
        /// <param name="CourseId"></param>
        /// <returns></returns>
        public RB_Course_ViewModel GetCourseModule(object CourseId)
        {
            return courseRepository.GetEntity<RB_Course_ViewModel>(CourseId);
        }

        /// <summary>
        /// 新增修改课程
        /// </summary>
        /// <returns></returns>
        public bool SetCourseModule(RB_Course_ViewModel model)
        {
            bool flag;
            if (model.CourseId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Course_ViewModel.CoverImg),model.CoverImg },
                    {nameof(RB_Course_ViewModel.CourseName),model.CourseName },
                    {nameof(RB_Course_ViewModel.CourseIntro),model.CourseIntro },
                    {nameof(RB_Course_ViewModel.CateId),model.CateId },
                };
                flag = courseRepository.Update(fileds, new WhereHelper(nameof(RB_Course_ViewModel.CourseId), model.CourseId));
            }
            else
            {
                var newId = courseRepository.Insert(model);
                model.CourseId = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 是否显示章节编号
        /// </summary>
        /// <param name="CourseId"></param>
        /// <param name="IsShowChapterNo">是否显示章节编号(1-显示，0-不显示)</param>
        /// <returns></returns>
        public bool SetCourseIsShowChapterNoModule(int CourseId, int IsShowChapterNo)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Course_ViewModel.IsShowChapterNo),IsShowChapterNo },
            };
            bool flag = courseRepository.Update(fileds, new WhereHelper(nameof(RB_Course_ViewModel.CourseId), CourseId));
            return flag;
        }

        /// <summary>
        /// 设置课程教师
        /// </summary>
        /// <param name="CourseId"></param>
        /// <param name="Teacher_Id">教师编号</param>
        /// <returns></returns>
        public bool SetCourseTeacherModule(int CourseId, int Teacher_Id)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Course_ViewModel.Teacher_Id),Teacher_Id },
            };
            bool flag = courseRepository.Update(fileds, new WhereHelper(nameof(RB_Course_ViewModel.CourseId), CourseId));
            return flag;
        }

        /// <summary>
        /// 删除课程
        /// </summary>
        /// <param name="CourseId"></param>
        /// <returns></returns>
        public bool RemoveCourseModule(object CourseId)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Course_ViewModel.Status),(int)DateStateEnum.Delete },
            };
            bool flag = courseRepository.Update(fileds, new WhereHelper(nameof(RB_Course_ViewModel.CourseId), CourseId));
            return flag;
        }

        #endregion

        #region 课程通知管理
        /// <summary>
        /// 获取课程通知分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course_Notice_ViewModel> GetNoticePageListModule(int pageIndex, int pageSize, out long rowsCount, RB_Course_Notice_ViewModel query)
        {
            return noticeRepository.GetNoticePageListRepository(pageIndex, pageSize, out rowsCount, query);
        }

        /// <summary>
        /// 新增修改课程通知
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetNoticeModule(RB_Course_Notice_ViewModel model)
        {
            bool flag;
            if (model.NoticeId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Course_Notice_ViewModel.Title),model.Title }
                };
                flag = noticeRepository.Update(fileds, new WhereHelper(nameof(RB_Course_Notice_ViewModel.NoticeId), model.NoticeId));
            }
            else
            {
                var newId = noticeRepository.Insert(model);
                model.NoticeId = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 获取课程通知实体
        /// </summary>
        /// <param name="NoticeId"></param>
        /// <returns></returns>
        public RB_Course_Notice_ViewModel GetNoticeModule(object NoticeId)
        {
            return noticeRepository.GetEntity<RB_Course_Notice_ViewModel>(NoticeId);
        }

        /// <summary>
        /// 根据通知编号删除通知
        /// </summary>
        /// <param name="NoticeId"></param>
        /// <returns></returns>
        public bool RemoveNoticeModule(object NoticeId)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Course_Notice_ViewModel.Status), (int)DateStateEnum.Delete}
            };
            bool flag = noticeRepository.Update(fileds, new WhereHelper(nameof(RB_Course_Notice_ViewModel.NoticeId), NoticeId));
            return flag;
        }

        /// <summary>
        /// 新增通知阅读
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddNoticeRevice(RB_Course_NoticeRevice_ViewModel model)
        {
            var newId = noticeReviceRepository.Insert(model);
            model.ReviceId = newId;
            return newId > 0;
        }

        #endregion

        #region 课程章节管理

        /// <summary>
        /// 获取课程章节列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course_Chapter_ViewModel> GetChapterListModule(RB_Course_Chapter_ViewModel query)
        {
            return chapterRepository.GetChapterListRepository(query);
        }

        /// <summary>
        /// 新增修改课程章节
        /// </summary>
        /// <returns></returns>
        public bool SetChapterModule(RB_Course_Chapter_ViewModel model)
        {
            bool flag;
            if (model.ChapterId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Course_Chapter_ViewModel.ChapterNo) ,model.ChapterNo},
                    {nameof(RB_Course_Chapter_ViewModel.ChapterName) ,model.ChapterName},
                    {nameof(RB_Course_Chapter_ViewModel.ChapterContent) ,model.ChapterContent},
                    {nameof(RB_Course_Chapter_ViewModel.ParentId) ,model.ParentId},
                };
                flag = chapterRepository.Update(fileds, new WhereHelper(nameof(RB_Course_Chapter_ViewModel.ChapterId), model.ChapterId));
            }
            else
            {
                var newId = chapterRepository.Insert(model);
                model.ChapterId = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 获取章节实体类
        /// </summary>
        /// <param name="ChapterId"></param>
        /// <returns></returns>
        public RB_Course_Chapter_ViewModel GetChapterModule(object ChapterId)
        {
            return chapterRepository.GetEntity<RB_Course_Chapter_ViewModel>(ChapterId);
        }

        /// <summary>
        /// 删除章节
        /// </summary>
        /// <param name="ChapterId"></param>
        /// <returns></returns>
        public bool RemoveChapterModule(object ChapterId)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Course_Chapter_ViewModel.Status) ,(int)DateStateEnum.Delete},
            };
            bool flag = chapterRepository.Update(fileds, new WhereHelper(nameof(RB_Course_Chapter_ViewModel.ChapterId), ChapterId));
            return flag;
        }

        /// <summary>
        /// 设置章节开发状态
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetChapterOpenStatusModule(RB_Course_Chapter_ViewModel model)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Course_Chapter_ViewModel.OpenStatus) ,model.OpenStatus},
                {nameof(RB_Course_Chapter_ViewModel.OpenStart) ,model.OpenStart},
                {nameof(RB_Course_Chapter_ViewModel.OpenEnd) ,model.OpenEnd},
            };
            bool flag = chapterRepository.Update(fileds, new WhereHelper(nameof(RB_Course_Chapter_ViewModel.ChapterId), model.ChapterId));
            return flag;
        }

        /// <summary>
        /// 设置章节进度
        /// </summary>
        /// <param name="ChapterId"></param>
        /// <param name="Progress"></param>
        /// <returns></returns>
        public bool SetChapterProgressModule(object ChapterId, int Progress)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Course_Chapter_ViewModel.Progress) ,Progress},
            };
            bool flag = chapterRepository.Update(fileds, new WhereHelper(nameof(RB_Course_Chapter_ViewModel.ChapterId), ChapterId));
            return flag;
        }

        #endregion

        #region 课程讨论管理

        /// <summary>
        /// 获取课程讨论分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course_Discuss_ViewModel> GetDiscussPageListModule(int pageIndex, int pageSize, out long rowsCount, RB_Course_Discuss_ViewModel query)
        {
            return discussRepository.GetDiscussPageListRepository(pageIndex, pageSize, out rowsCount, query);
        }

        /// <summary>
        /// 新增修改讨论话题
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetDiscussModule(RB_Course_Discuss_ViewModel model)
        {
            bool flag;
            if (model.DiscussId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Course_Discuss_ViewModel.DiscussTitle),model.DiscussTitle },
                    {nameof(RB_Course_Discuss_ViewModel.DiscussContent),model.DiscussContent },
                    {nameof(RB_Course_Discuss_ViewModel.DiscussUrl),model.DiscussUrl },
                };
                flag = discussRepository.Update(fileds, new WhereHelper(nameof(RB_Course_Discuss_ViewModel.DiscussId), model.DiscussId));
            }
            else
            {
                var newId = discussRepository.Insert(model);
                model.DiscussId = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 获取讨论话题
        /// </summary>
        /// <param name="DiscussId"></param>
        /// <returns></returns>
        public RB_Course_Discuss_ViewModel GetDiscussModule(object DiscussId)
        {
            return discussRepository.GetEntity<RB_Course_Discuss_ViewModel>(DiscussId);
        }

        /// <summary>
        /// 删除讨论话题
        /// </summary>
        /// <param name="DiscussId"></param>
        /// <returns></returns>
        public bool RemoveDiscussModule(object DiscussId)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Course_Discuss_ViewModel.Status),(int)DateStateEnum.Delete },
            };
            bool flag = discussRepository.Update(fileds, new WhereHelper(nameof(RB_Course_Discuss_ViewModel.DiscussId), DiscussId));
            return flag;
        }

        #endregion

        #region 课程配置
        /// <summary>
        /// 新增修改课程配置
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetCourseSettingModule(RB_Course_Setting_ViewModel model)
        {
            var oldModel = settingRepository.GetCourseSettingRepository(model);
            bool flag;
            if (oldModel != null && oldModel.SettingId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Course_Setting_ViewModel.AppIsCache),model.AppIsCache },
                    {nameof(RB_Course_Setting_ViewModel.PlayType),model.PlayType },
                };
                flag = settingRepository.Update(fileds, new WhereHelper(nameof(RB_Course_Setting_ViewModel.SettingId), oldModel.SettingId));
            }
            else
            {
                var newId = settingRepository.Insert(model);
                model.SettingId = newId;
                flag = newId > 0;
            }
            return flag;
        }
        #endregion

        #region 课程资料管理

        /// <summary>
        /// 获取课程资料分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course_Source_ViewModel> GetSourcePageListModule(int pageIndex, int pageSize, out long rowsCount, RB_Course_Source_ViewModel query)
        {
            return sourceRepository.GetSourcePageListRepository(pageIndex, pageSize, out rowsCount, query);
        }

        /// <summary>
        /// 新增修改课程资料
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetCourseSourceModule(RB_Course_Source_ViewModel model)
        {
            bool flag;
            if (model.SourceId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Course_Source_ViewModel.SourceName),model.SourceName },
                    {nameof(RB_Course_Source_ViewModel.SourceType),model.SourceType },
                    {nameof(RB_Course_Source_ViewModel.SourceUrl),model.SourceUrl },
                    {nameof(RB_Course_Source_ViewModel.SourceSize),model.SourceSize },
                    {nameof(RB_Course_Source_ViewModel.ParentSourceId),model.ParentSourceId },
                };
                flag = sourceRepository.Update(fileds, new WhereHelper(nameof(RB_Course_Source_ViewModel.SourceId), model.SourceId));
            }
            else
            {
                var newId = sourceRepository.Insert(model);
                model.SourceId = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 根据编号获取课程资料实体
        /// </summary>
        /// <param name="SourceId"></param>
        /// <returns></returns>
        public RB_Course_Source_ViewModel GetCourseSourceModule(object SourceId)
        {
            return sourceRepository.GetEntity<RB_Course_Source_ViewModel>(SourceId);
        }


        /// <summary>
        /// 更新资料共享类型
        /// </summary>
        /// <param name="SourceId"></param>
        /// <param name="ShareType">共享类型</param>
        /// <returns></returns>
        public bool SetCourseSourceShareTypeModule(object SourceId, int ShareType)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Course_Source_ViewModel.ShareType),ShareType},
            };
            bool flag = sourceRepository.Update(fileds, new WhereHelper(nameof(RB_Course_Source_ViewModel.SourceId), SourceId));
            return flag;
        }

        /// <summary>
        /// 根据编号删除课程资料
        /// </summary>
        /// <param name="SourceId"></param>
        /// <returns></returns>
        public bool RemoveCourseSourceModule(object SourceId)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Course_Source_ViewModel.Status),(int)DateStateEnum.Delete},
            };
            bool flag = sourceRepository.Update(fileds, new WhereHelper(nameof(RB_Course_Source_ViewModel.SourceId), SourceId));
            return flag;
        }

        #endregion

        #region 课程教案管理

        /// <summary>
        /// 获取课程教案分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course_TeachPlan_ViewModel> GetCourseTeachPlanPageListModule(int pageIndex, int pageSize, out long rowsCount, RB_Course_TeachPlan_ViewModel query)
        {
            return teachPlanRepository.GetCourseTeachPlanPageListRepository(pageIndex, pageSize, out rowsCount, query);
        }

        /// <summary>
        /// 添加修改课程教案
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetTeachPlanModule(RB_Course_TeachPlan_ViewModel model)
        {
            bool flag;
            if (model.PlanId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Course_TeachPlan_ViewModel.PlanName),model.PlanName },
                    {nameof(RB_Course_TeachPlan_ViewModel.ClassBefore),model.ClassBefore },
                    {nameof(RB_Course_TeachPlan_ViewModel.ClassIn),model.ClassIn },
                    {nameof(RB_Course_TeachPlan_ViewModel.ClassAfter),model.ClassAfter },
                    {nameof(RB_Course_TeachPlan_ViewModel.ParentPlanId),model.ParentPlanId },
                    {nameof(RB_Course_TeachPlan_ViewModel.SourceUrl),model.SourceUrl },
                    {nameof(RB_Course_TeachPlan_ViewModel.PlanFileExtension),model.PlanFileExtension },
                    {nameof(RB_Course_TeachPlan_ViewModel.PlanNodeType),model.PlanNodeType },
                    {nameof(RB_Course_TeachPlan_ViewModel.ExtUrl),model.ExtUrl },
                    {nameof(RB_Course_TeachPlan_ViewModel.Remark),model.Remark },
                    {nameof(RB_Course_TeachPlan_ViewModel.IsTop),model.IsTop },
                };
                flag = teachPlanRepository.Update(fileds, new WhereHelper(nameof(RB_Course_TeachPlan_ViewModel.PlanId), model.PlanId));
            }
            else
            {
                var newId = teachPlanRepository.Insert(model);
                model.PlanId = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 根据编号获取教案实体
        /// </summary>
        /// <param name="PlanId"></param>
        /// <returns></returns>
        public RB_Course_TeachPlan_ViewModel GetTeachPlanModule(object PlanId)
        {
            return teachPlanRepository.GetEntity<RB_Course_TeachPlan_ViewModel>(PlanId);
        }

        /// <summary>
        /// 删除教案
        /// </summary>
        /// <param name="PlanId"></param>
        /// <returns></returns>
        public bool RemoveTeachPlanModule(object PlanId)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Course_TeachPlan_ViewModel.Status),(int)DateStateEnum.Delete },
            };
            bool flag = teachPlanRepository.Update(fileds, new WhereHelper(nameof(RB_Course_TeachPlan_ViewModel.PlanId), PlanId));
            return flag;
        }

        #endregion

        #region 课程作业管理

        /// <summary>
        /// 新增修改课程作业
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetCourseJobModule(RB_Course_Job_ViewModel model)
        {
            bool flag;
            if (model.JobId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Course_Job_ViewModel.JobName),model.JobName },
                    {nameof(RB_Course_Job_ViewModel.ScoreType),model.ScoreType },
                    {nameof(RB_Course_Job_ViewModel.TopicType),model.TopicType },
                    {nameof(RB_Course_Job_ViewModel.ReciveClass),model.ReciveClass },
                    {nameof(RB_Course_Job_ViewModel.StartTime),model.StartTime },
                    {nameof(RB_Course_Job_ViewModel.EndTime),model.EndTime },
                    {nameof(RB_Course_Job_ViewModel.IsAllowDelay),model.IsAllowDelay },
                    {nameof(RB_Course_Job_ViewModel.PassBasicScore),model.PassBasicScore },
                    {nameof(RB_Course_Job_ViewModel.IsAgain),model.IsAgain },
                    {nameof(RB_Course_Job_ViewModel.AgainTimes),model.AgainTimes },
                    {nameof(RB_Course_Job_ViewModel.IsGetHighScore),model.IsGetHighScore },
                    {nameof(RB_Course_Job_ViewModel.IsLookAnswer),model.IsLookAnswer },
                    {nameof(RB_Course_Job_ViewModel.LookAnswerType),model.LookAnswerType },
                    {nameof(RB_Course_Job_ViewModel.IsLookScore),model.IsLookScore },
                    {nameof(RB_Course_Job_ViewModel.IsLookQTypeScore),model.IsLookQTypeScore },
                    {nameof(RB_Course_Job_ViewModel.IsPaste),model.IsPaste },
                    {nameof(RB_Course_Job_ViewModel.IsAgainShowTrueFalse),model.IsAgainShowTrueFalse },
                    {nameof(RB_Course_Job_ViewModel.IsOutOrder),model.IsOutOrder },
                    {nameof(RB_Course_Job_ViewModel.IsRandom),model.IsRandom },
                    {nameof(RB_Course_Job_ViewModel.RandomNum),model.RandomNum },
                    {nameof(RB_Course_Job_ViewModel.IsSendMsg),model.IsSendMsg },
                    {nameof(RB_Course_Job_ViewModel.SendMsgHour),model.SendMsgHour },
                    {nameof(RB_Course_Job_ViewModel.IsWork),model.IsWork },
                    {nameof(RB_Course_Job_ViewModel.WorkProcess),model.WorkProcess },
                    {nameof(RB_Course_Job_ViewModel.IsBlankobj),model.IsBlankobj },
                    {nameof(RB_Course_Job_ViewModel.IsCompletionIngoreCase),model.IsCompletionIngoreCase },
                    {nameof(RB_Course_Job_ViewModel.IsBlankIgnoreComma),model.IsBlankIgnoreComma },
                    {nameof(RB_Course_Job_ViewModel.IsMultiHalfScore),model.IsMultiHalfScore },
                };
                flag = courseJobRepository.Update(fileds, new WhereHelper(nameof(RB_Course_Job_ViewModel.JobId), model.JobId));
            }
            else
            {
                var newId = courseJobRepository.Insert(model);
                model.JobId = newId;
                flag = newId > 0;
            }
            return flag;
        }

        #endregion
    }
}