﻿using Edu.AOP.CustomerAttribute;
using Edu.Common.Enum;
using Edu.Model.ViewModel.Question;
using Edu.Repository.Question;
using System.Collections.Generic;
using VT.FW.DB;

namespace Edu.Module.Question
{
    /// <summary>
    /// 题库处理类
    /// </summary>
    public class QuestionModule
    {
        /// <summary>
        /// 题目类型仓储层对象
        /// </summary>
        private readonly RB_Question_TypeRepository question_TypeRepository = new RB_Question_TypeRepository();

        /// <summary>
        /// 题库仓储层对象
        /// </summary>
        private readonly RB_QuestionRepository questionRepository = new RB_QuestionRepository();


        /// <summary>
        /// 知识点仓储层对象
        /// </summary>
        private readonly RB_Question_PointRepository question_PointRepository = new RB_Question_PointRepository();

        /// <summary>
        /// 获取题目类型列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Question_Type_ViewModel> GetQuestionTypeListModule(RB_Question_Type_ViewModel query)
        {
            return question_TypeRepository.GetQuestionTypeListRepository(query);
        }

        /// <summary>
        /// 获取题库分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Question_ViewModel> GetQuestionPageListModule(int pageIndex, int pageSize, out long rowsCount, RB_Question_ViewModel query)
        {
            return questionRepository.GetQuestionPageListRepository(pageIndex, pageSize, out rowsCount, query);
        }

        /// <summary>
        /// 获取题库列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Question_ViewModel> GetQuestionListModule(RB_Question_ViewModel query)
        {
            return questionRepository.GetQuestionListRepository(query);
        }

        /// <summary>
        /// 新增修改题目
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetQuestionModule(RB_Question_ViewModel model)
        {
            bool flag;
            if (model.QuestionId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Question_ViewModel.Title),model.Title },
                    {nameof(RB_Question_ViewModel.DifficultyType),(int)model.DifficultyType },
                    {nameof(RB_Question_ViewModel.AnswerParse),model.AnswerParse },
                    {nameof(RB_Question_ViewModel.QuestionTypeId),model.QuestionTypeId },
                    {nameof(RB_Question_ViewModel.Knowledge),model.Knowledge },
                    {nameof(RB_Question_ViewModel.IsUpdateJobExam),model.IsUpdateJobExam },
                    {nameof(RB_Question_ViewModel.UpdateBy),model.UpdateBy },
                    {nameof(RB_Question_ViewModel.UpdateTime),model.UpdateTime },
                    {nameof(RB_Question_ViewModel.Answer),model.Answer },
                    {nameof(RB_Question_ViewModel.Score),model.Score },
                };
                flag = questionRepository.Update(fileds, new WhereHelper(nameof(RB_Question_ViewModel.QuestionId), model.QuestionId));
            }
            else
            {
                var newId = questionRepository.Insert(model);
                model.QuestionId = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 删除问题
        /// </summary>
        /// <param name="QuestionId"></param>
        /// <returns></returns>
        public bool RemoveQuestionModule(object QuestionId)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Question_ViewModel.Status),(int )DateStateEnum.Delete},
            };
            bool flag = questionRepository.Update(fileds, new WhereHelper(nameof(RB_Question_ViewModel.QuestionId), QuestionId));
            return flag;
        }

        /// <summary>
        /// 更新问题排序
        /// </summary>
        /// <returns></returns>
        [TransactionCallHandler]
        public virtual bool UpdateQuestionSortModule(int curQId,int targetQId)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Question_ViewModel.SortNum),targetQId},
            };
            bool flag = questionRepository.Update(fileds, new WhereHelper(nameof(RB_Question_ViewModel.QuestionId), curQId));
            if (flag)
            {
                //排序修改
                Dictionary<string, object> fileds2 = new Dictionary<string, object>()
                {
                    {nameof(RB_Question_ViewModel.SortNum),curQId},
                };
                flag = questionRepository.Update(fileds2, new WhereHelper(nameof(RB_Question_ViewModel.QuestionId), targetQId));
            }
            return flag;
        }

        /// <summary>
        /// 根据编号获取问题实体
        /// </summary>
        /// <param name="QuestionId"></param>
        /// <returns></returns>
        public RB_Question_ViewModel GetQuestionModule(object QuestionId)
        {
            return questionRepository.GetEntity<RB_Question_ViewModel>(QuestionId);
        }

        /// <summary>
        /// 获取问题知识点列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Question_Point_ViewModel> GetPointListModule(RB_Question_Point_ViewModel query)
        {
            return question_PointRepository.GetPointListRepository(query);
        }

        /// <summary>
        /// 获取知识点分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Question_Point_ViewModel> GetPointPageListModule(int pageIndex, int pageSize, out long rowsCount, RB_Question_Point_ViewModel query)
        {
            return question_PointRepository.GetPointPageListRepository(pageIndex, pageSize, out rowsCount, query);
        }

        /// <summary>
        /// 根据知识点编号获取知识点
        /// </summary>
        /// <param name="PointId"></param>
        /// <returns></returns>
        public RB_Question_Point_ViewModel GetQuestionPointModule(object PointId)
        {
            return question_PointRepository.GetEntity<RB_Question_Point_ViewModel>(PointId);
        }

        /// <summary>
        /// 新增修改知识点
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetQuestionPointModule(RB_Question_Point_ViewModel model)
        {
            bool flag;
            if (model.PointId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Question_Point_ViewModel.PointName),model.PointName.Trim() }
                };
                flag = question_PointRepository.Update(fileds, new WhereHelper(nameof(RB_Question_Point_ViewModel.PointId), model.PointId));
            }
            else
            {
                var newId = question_PointRepository.Insert(model);
                model.PointId = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 根据编号删除知识点
        /// </summary>
        /// <param name="PointId"></param>
        /// <returns></returns>
        public bool RemoveQuestionPointModule(object PointId)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Question_Point_ViewModel.Status), (int)DateStateEnum.Delete }
            };
            bool flag = question_PointRepository.Update(fileds, new WhereHelper(nameof(RB_Question_Point_ViewModel.PointId), PointId));
            return flag;
        }
    }
}