﻿using Edu.Model.ViewModel.System;
using Edu.Repository.System;
using System.Collections.Generic;
using System.Linq;

namespace Edu.Module.System
{
    /// <summary>
    /// 地区处理类
    /// </summary>
    public class DestinationModule
    {
        /// <summary>
        /// 地区仓储层对象
        /// </summary>
        private readonly RB_DestinationRepository destinationRepository = new RB_DestinationRepository();

        /// <summary>
        /// 省市区树形列表
        /// </summary>
        /// <returns></returns>
        public List<AreaTree_ViewModel> GetAreaTree()
        {
            List<AreaTree_ViewModel> treeList = new List<AreaTree_ViewModel>();
            var list = destinationRepository.GetDestinationListRepository(new RB_Destination_ViewModel() { });
            if (list != null && list.Count > 0)
            {
                var firstList = list.Where(qitem => qitem.CodeLevel == 2).ToList();
                if (firstList != null && firstList.Count > 0)
                {
                    foreach (var fItem in firstList)
                    {
                        AreaTree_ViewModel fModel = new AreaTree_ViewModel()
                        {
                            ID = fItem.ID,
                            Name = fItem.Name,
                            ParentID = fItem.ParentID,
                            ChildList = new List<AreaTree_ViewModel>()
                        };
                        var secondList = list.Where(qitem => qitem.CodeLevel == 3 && qitem.ParentID == fItem.ID).ToList();
                        if (secondList != null && secondList.Count > 0)
                        {
                            foreach (var sItem in secondList)
                            {
                                AreaTree_ViewModel sModel = new AreaTree_ViewModel()
                                {
                                    ID = sItem.ID,
                                    Name = sItem.Name,
                                    ParentID = sItem.ParentID,
                                    ChildList = new List<AreaTree_ViewModel>()
                                };
                                var thirdList= list.Where(qitem => qitem.CodeLevel == 4 && qitem.ParentID == sItem.ID).ToList();
                                if (thirdList != null && thirdList.Count > 0)
                                {
                                    foreach (var tItem in thirdList)
                                    {
                                        sModel.ChildList.Add(new AreaTree_ViewModel()
                                        {
                                            ID = tItem.ID,
                                            Name = tItem.Name,
                                            ParentID = tItem.ParentID,
                                            ChildList = new List<AreaTree_ViewModel>()
                                        });
                                    }
                                }
                                fModel.ChildList.Add(sModel);
                            }
                        }
                        treeList.Add(fModel);
                    }
                }
            }
            return treeList;
        }
    }
}