﻿using Edu.Model.ViewModel.User;
using Edu.Repository.User;
using System.Collections.Generic;
using VT.FW.DB;

namespace Edu.Module.User
{
    /// <summary>
    /// 账号管理处理类
    /// </summary>
    public class AccountModule
    {
        /// <summary>
        /// 账号管理处理类对象
        /// </summary>
        private readonly RB_AccountRepository accountRepository = new RB_AccountRepository();

        /// <summary>
        /// 获取账号列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Account_ViewModel> GetAccountListModule(RB_Account_ViewModel query)
        {
            return accountRepository.GetAccountListRepository(query);
        }

        /// <summary>
        /// 获取账号分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Account_ViewModel> GetAccountPageListModule(int pageIndex, int pageSize, out long rowsCount, RB_Account_ViewModel query)
        {
            return accountRepository.GetAccountPageListRepository(pageIndex, pageSize, out rowsCount, query);
        }

        /// <summary>
        /// 获取账号列表扩展列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Account_ViewModel> GetAccountListExtModule(RB_Account_ViewModel query)
        {
            return accountRepository.GetAccountListExtRepository(query);
        }

        /// <summary>
        /// 添加修改账号
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetAccountModule(RB_Account_ViewModel model)
        {
            bool flag;
            if (model.Id > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Account_ViewModel.Account),model.Account.Trim() },
                    {nameof(RB_Account_ViewModel.AccountType),model.AccountType},
                    {nameof(RB_Account_ViewModel.AccountId),model.AccountId},
                    {nameof(RB_Account_ViewModel.UpdateBy),model.UpdateBy},
                    {nameof(RB_Account_ViewModel.UpdateTime),model.UpdateTime},
                };
                flag = accountRepository.Update(fileds, new WhereHelper(nameof(RB_Account_ViewModel.Id), model.Id));
            }
            else
            {
                var newId = accountRepository.Insert(model);
                model.Id = newId;
                flag = newId > 0;
            }
            return flag;
        }
    }
}