﻿using Edu.Common.Enum;
using Edu.Model.ViewModel.User;
using Edu.Repository.User;
using System.Collections.Generic;
using System.Linq;
using VT.FW.DB;

namespace Edu.Module.User
{
    /// <summary>
    /// 学校校区处理类
    /// </summary>
    public class SchoolModule
    {
        /// <summary>
        /// 学校仓储层对象
        /// </summary>
        private readonly RB_SchoolRepository schoolRepository = new RB_SchoolRepository();

        /// <summary>
        /// 获取学校列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_School_ViewModel> GetSchoolListModule(RB_School_ViewModel query)
        {
            return schoolRepository.GetSchoolListRepository(query);
        }

        /// <summary>
        /// 获取学校分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_School_ViewModel> GetSchoolPageListModule(int pageIndex, int pageSize, out long rowsCount, RB_School_ViewModel query)
        {
            return schoolRepository.GetSchoolPageListRepository(pageIndex, pageSize, out rowsCount, query);
        }

        /// <summary>
        /// 获取学校实体类
        /// </summary>
        /// <param name="GId"></param>
        /// <returns></returns>
        public RB_School_ViewModel GetSchoolEntityModule(int SId)
        {
            return GetSchoolListModule(new RB_School_ViewModel() { SId = SId })?.FirstOrDefault() ?? new RB_School_ViewModel();
        }

        /// <summary>
        /// 新增修改学校
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public virtual bool SetSchoolModule(RB_School_ViewModel model)
        {
            bool flag;
            if (model.SId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_School_ViewModel.SName),model.SName.Trim() },
                    {nameof(RB_School_ViewModel.SAddress),model.SAddress},
                    {nameof(RB_School_ViewModel.SLinkMan),model.SLinkMan.Trim() },
                    {nameof(RB_School_ViewModel.SLinkTel),model.SLinkTel.Trim() },
                    {nameof(RB_School_ViewModel.SDomain),model.SDomain },
                    {nameof(RB_School_ViewModel.SLogo),model.SLogo },
                    {nameof(RB_School_ViewModel.Remark),model.Remark },
                    {nameof(RB_School_ViewModel.UpdateBy),model.UpdateBy },
                    {nameof(RB_School_ViewModel.UpdateTime),model.UpdateTime },
                    {nameof(RB_School_ViewModel.Status),model.Status }
                };
                flag = schoolRepository.Update(fileds, new WhereHelper(nameof(RB_School_ViewModel.SId), model.SId));
            }
            else
            {
                var newId = schoolRepository.Insert(model);
                model.SId = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 判断学校是否存在
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public bool ExistsSchoolModule(RB_School_ViewModel query)
        {
            List<WhereHelper> wheres = new List<WhereHelper>()
            {
                new WhereHelper(nameof(RB_School_ViewModel.SName),query.SName.Trim()),
                new WhereHelper(nameof(RB_School_ViewModel.Group_Id),query.Group_Id),
            };
            if (query.SId > 0)
            {
                wheres.Add(new WhereHelper(nameof(RB_School_ViewModel.SId), query.SId, OperatorEnum.NotEqual));
            }
            return schoolRepository.Exists(wheres);
        }

        /// <summary>
        /// 删除学校
        /// </summary>
        /// <param name="SId">学校编号</param>
        /// <returns></returns>
        public virtual bool RemoveSchoolModule(object SId)
        {
            bool flag;
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_School_ViewModel.Status),(int)DateStateEnum.Delete },
            };
            flag = schoolRepository.Update(fileds, new WhereHelper(nameof(RB_School_ViewModel.SId), SId));
            return flag;
        }
    }
}