﻿using Edu.Common.Enum;
using Edu.Model.ViewModel.User;
using Edu.Repository.User;
using System.Collections.Generic;
using VT.FW.DB;

namespace Edu.Module.User
{
    /// <summary>
    /// 学生处理类
    /// </summary>
    public class StudentModule
    {
        /// <summary>
        /// 学生仓储层对象
        /// </summary>
        private readonly RB_StudentRepository studentRepository = new RB_StudentRepository();

        /// <summary>
        /// 获取学生列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Student_ViewModel> GetStudentListModule(RB_Student_ViewModel query)
        {
            return studentRepository.GetStudentListRepository(query);
        }

        /// <summary>
        /// 获取学生分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Student_ViewModel> GetStudentPageListModule(int pageIndex, int pageSize, out long rowsCount, RB_Student_ViewModel query)
        {
            return studentRepository.GetStudentPageListRepository(pageIndex, pageSize, out rowsCount, query);
        }

        /// <summary>
        /// 添加修改讲师
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetStudentModule(RB_Student_ViewModel model)
        {
            bool flag;
            if (model.StuId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Student_ViewModel.StuName),model.StuName.Trim() },
                    {nameof(RB_Student_ViewModel.StuTel),model.StuTel.Trim() },
                    {nameof(RB_Student_ViewModel.StuIcon),model.StuIcon.Trim() },
                    {nameof(RB_Student_ViewModel.StuSex),model.StuSex },
                    {nameof(RB_Student_ViewModel.StuBirth),model.StuBirth },
                    {nameof(RB_Student_ViewModel.ProviceId),model.ProviceId },
                    {nameof(RB_Student_ViewModel.CityId),model.CityId },
                    {nameof(RB_Student_ViewModel.AreaId),model.AreaId },
                };
                flag = studentRepository.Update(fileds, new WhereHelper(nameof(RB_Student_ViewModel.StuId), model.StuId));
            }
            else
            {
                var newId = studentRepository.Insert(model);
                model.StuId = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 根据学生编号获取学生实体类
        /// </summary>
        /// <param name="StuId"></param>
        /// <returns></returns>
        public RB_Student_ViewModel GetStudentModule(int StuId)
        {
            return studentRepository.GetEntity<RB_Student_ViewModel>(StuId);
        }

        /// <summary>
        /// 删除学生
        /// </summary>
        /// <param name="StuId"></param>
        /// <returns></returns>
        public bool RemoveStudentModule(object StuId)
        {
            bool flag;
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Student_ViewModel.Status),  (int)DateStateEnum.Delete},
            };
            flag = studentRepository.Update(fileds, new WhereHelper(nameof(RB_Student_ViewModel.StuId), StuId));
            return flag;
        }

        /// <summary>
        /// 更新学员【禁用、启用】
        /// </summary>
        /// <param name="StuId"></param>
        /// <param name="IsDisable">0-禁用，1-启用</param>
        /// <returns></returns>
        public bool UpdateStudentIsDisableModule(object StuId,int IsDisable)
        {
            bool flag;
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Student_ViewModel.IsDisable),  IsDisable},
            };
            flag = studentRepository.Update(fileds, new WhereHelper(nameof(RB_Student_ViewModel.StuId), StuId));
            return flag;
        }
    }
}
