﻿using Edu.AOP.CustomerAttribute;
using Edu.Common.Enum;
using Edu.Common.Enum.User;
using Edu.Model.CacheModel;
using Edu.Model.ViewModel.User;
using Edu.Repository.User;
using System;
using System.Collections.Generic;
using System.Linq;
using VT.FW.DB;

namespace Edu.Module.User
{
    /// <summary>
    /// 教师处理类
    /// </summary>
    public class TeacherModule
    {
        /// <summary>
        /// 讲师仓储层对象
        /// </summary>
        private readonly RB_TeacherRepository teacherRepository = new RB_TeacherRepository();

        /// <summary>
        /// 账号处理类
        /// </summary>
        private readonly AccountModule accountModule = new AccountModule();

        /// <summary>
        /// 获取讲师列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Teacher_ViewModel> GetTeacherListModule(RB_Teacher_ViewModel query)
        {
            return teacherRepository.GetTeacherListRepository(query);
        }


        /// <summary>
        /// 获取讲师分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Teacher_ViewModel> GetTeacherPageListModule(int pageIndex, int pageSize, out long rowsCount, RB_Teacher_ViewModel query)
        {
            return teacherRepository.GetTeacherPageListRepository(pageIndex, pageSize, out rowsCount, query);
        }

        /// <summary>
        /// 新增修改讲师
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetTeacherModule(RB_Teacher_ViewModel model)
        {
            bool flag;
            if (model.TId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Teacher_ViewModel.TeacherName),model.TeacherName },
                    {nameof(RB_Teacher_ViewModel.TeacherTel),model.TeacherTel },
                    {nameof(RB_Teacher_ViewModel.TeacherHead),model.TeacherHead },
                    {nameof(RB_Teacher_ViewModel.TeacherIcon),model.TeacherIcon },
                    {nameof(RB_Teacher_ViewModel.TeacherSay),model.TeacherSay },
                    {nameof(RB_Teacher_ViewModel.TeacherIntro),model.TeacherIntro },
                    {nameof(RB_Teacher_ViewModel.IsShow),model.IsShow },
                    {nameof(RB_Teacher_ViewModel.IsRecommend),model.IsRecommend },
                    {nameof(RB_Teacher_ViewModel.SortNum),model.SortNum },
                    {nameof(RB_Teacher_ViewModel.UpdateBy),model.UpdateBy },
                    {nameof(RB_Teacher_ViewModel.UpdateTime),model.UpdateTime },
                    {nameof(RB_Teacher_ViewModel.AuditStatus),model.AuditStatus },
                    {nameof(RB_Teacher_ViewModel.CourseCount),model.CourseCount },
                    {nameof(RB_Teacher_ViewModel.OnlineClassCount),model.OnlineClassCount },
                    {nameof(RB_Teacher_ViewModel.OnlineOrderCount),model.OnlineOrderCount },
                    {nameof(RB_Teacher_ViewModel.TeachTag),model.TeachTag }
                };
                flag = teacherRepository.Update(fileds, new WhereHelper(nameof(RB_Teacher_ViewModel.TId), model.TId));
            }
            else
            {
                var newId = teacherRepository.Insert(model);
                model.TId = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 根据教师编号获取实体
        /// </summary>
        /// <param name="TId"></param>
        /// <returns></returns>
        public RB_Teacher_ViewModel GetTeacherModule(int TId)
        {
            return GetTeacherListModule(new RB_Teacher_ViewModel() { TId = TId })?.FirstOrDefault() ?? new RB_Teacher_ViewModel();
        }

        /// <summary>
        /// 删除讲师
        /// </summary>
        /// <param name="TId"></param>
        /// <returns></returns>
        public bool RemoveTeacherModule(object TId)
        {
            bool flag;
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Teacher_ViewModel.Status),(int)DateStateEnum.Delete },
            };
            flag = teacherRepository.Update(fileds, new WhereHelper(nameof(RB_Teacher_ViewModel.TId), TId));
            return flag;
        }

        /// <summary>
        /// 讲师审核
        /// </summary>
        /// <param name="TId">教师编号</param>
        /// <param name="AuditStatus">审核状态</param>
        /// <param name="AuditRemark">审核备注</param>
        /// <param name="user">用户信息</param>
        /// <returns></returns>
        [TransactionCallHandler]
        public virtual bool AuditTeacherModule(int TId,int AuditStatus,string AuditRemark, UserInfo user)
        {
            bool flag = false;
            var model = GetTeacherModule(TId);
            if (model!=null)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Teacher_ViewModel.AuditStatus),AuditStatus },
                    {nameof(RB_Teacher_ViewModel.AuditRemark),AuditRemark },
                };
                flag = teacherRepository.Update(fileds, new WhereHelper(nameof(RB_Teacher_ViewModel.TId), TId));
                AccountStatusEnum statusEnum = (AccountStatusEnum)AuditStatus;
                if (statusEnum == AccountStatusEnum.Pass && flag)
                {
                    flag = accountModule.SetAccountModule(new RB_Account_ViewModel()
                    {
                        Account = model.TeacherTel,
                        Password = Common.DES.Encrypt(Common.Config.DefaultPwd),
                        AccountType = AccountTypeEnum.Teacher,
                        AccountId = model.TId,
                        CreateBy = user.Id,
                        UpdateBy = user.Id,
                        CreateTime = DateTime.Now,
                        UpdateTime = DateTime.Now,
                        Group_Id = model.Group_Id,
                        School_Id = model.School_Id,
                    });
                }
            }
            return flag;
        }
    }
}
