﻿using Edu.Common.Enum;
using Edu.Model.ViewModel.Course;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;
using System.Data;

namespace Edu.Repository.Course
{
    /// <summary>
    /// 课程分类仓储层
    /// </summary>
    public class RB_Course_CategoryRepository : BaseRepository<Model.Entity.Course.RB_Course_Category>
    {
        /// <summary>
        /// 获取课程分类列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course_Category_ViewModel> GetCourseCategoryListRepository(RB_Course_Category_ViewModel query)
        {
            StringBuilder builder = new StringBuilder();
            var parameters = new DynamicParameters();
            builder.AppendFormat(@"
SELECT * 
FROM RB_Course_Category
WHERE 1=1 
");
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_Course_Category_ViewModel.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (query.Group_Id > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Course_Category_ViewModel.Group_Id),query.Group_Id);
                }
                if (query.School_Id > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Course_Category_ViewModel.School_Id), query.School_Id);
                }
                if (query.CateId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Course_Category_ViewModel.CateId), query.CateId);
                }
                if (!string.IsNullOrWhiteSpace(query.CateName))
                {
                    builder.AppendFormat(" AND {0} LIKE @CateName ", nameof(RB_Course_Category_ViewModel.CateName));
                    parameters.Add("CateName", "%" + query.CateName.Trim() + "%");
                }
                if (query.ParentId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Course_Category_ViewModel.ParentId), query.ParentId);
                }
            }
            return Get<RB_Course_Category_ViewModel>(builder.ToString(), parameters).ToList();
        }

        /// <summary>
        /// 获取课程分类分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course_Category_ViewModel> GetCourseCategoryPageListRepository(int pageIndex,int pageSize,out long rowsCount,RB_Course_Category_ViewModel query)
        {
            StringBuilder builder = new StringBuilder();
            var parameters = new DynamicParameters();
            builder.AppendFormat(@"
SELECT * 
FROM RB_Course_Category
WHERE 1=1 
");
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_Course_Category_ViewModel.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (query.Group_Id > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Course_Category_ViewModel.Group_Id), query.Group_Id);
                }
                if (query.School_Id > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Course_Category_ViewModel.School_Id), query.School_Id);
                }
                if (query.CateId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Course_Category_ViewModel.CateId), query.CateId);
                }
                if (!string.IsNullOrWhiteSpace(query.CateName))
                {
                    builder.AppendFormat(" AND {0} LIKE @CateName ", nameof(RB_Course_Category_ViewModel.CateName));
                    parameters.Add("CateName", "%" + query.CateName.Trim() + "%");
                }
                if (query.ParentId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Course_Category_ViewModel.ParentId), query.ParentId);
                }
            }
            return GetPage<RB_Course_Category_ViewModel>(pageIndex,pageSize,out rowsCount,builder.ToString(), parameters).ToList();
        }

        /// <summary>
        /// 获取所有子级分类
        /// </summary>
        /// <param name="cateIds">事例(1,5)</param>
        /// <returns></returns>
        public List<RB_Course_Category_ViewModel> GetChildCategoryListRepository(string cateIds)
        {
            var parameters = new DynamicParameters();
            string procName = "proc_getchildcategory";
            parameters.Add("QId", cateIds, direction: ParameterDirection.Input);
            return Get<RB_Course_Category_ViewModel>(procName, parameters,commandType: CommandType.StoredProcedure).ToList();
        }
    }
}