﻿using Edu.Model.ViewModel.Course;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Edu.Repository.Course
{
    /// <summary>
    /// 课程章节仓储层
    /// </summary>
    public class RB_Course_ChapterRepository : BaseRepository<Model.Entity.Course.RB_Course_Chapter>
    {
        /// <summary>
        /// 获取课程章节列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course_Chapter_ViewModel> GetChapterListRepository(RB_Course_Chapter_ViewModel query)
        {
            var parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM rb_course_chapter
WHERE 1=1 
");
            if (query != null)
            {
                if (query.CourseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Course_Chapter_ViewModel.CourseId), query.CourseId);
                }
                if (!string.IsNullOrWhiteSpace(query.CourseIds))
                {
                    builder.AppendFormat(" AND {0} IN({1}) ", nameof(RB_Course_Chapter_ViewModel.CourseId), query.CourseIds);
                }
            }
            return Get<RB_Course_Chapter_ViewModel>(builder.ToString(), parameters).ToList();
        }
    }
}
