﻿using Edu.Model.ViewModel.Course;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Edu.Repository.Course
{
    /// <summary>
    /// 课程通知仓储层
    /// </summary>
    public class RB_Course_NoticeRepository : BaseRepository<Model.Entity.Course.RB_Course_Notice>
    {
        /// <summary>
        /// 获取课程通知分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course_Notice_ViewModel> GetNoticePageListRepository(int pageIndex, int pageSize, out long rowsCount, RB_Course_Notice_ViewModel query)
        {
            var parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM rb_course_notice
WHERE 1=1 
");
            if (query != null)
            {
                if (query.CourseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Course_Notice_ViewModel.CourseId), query.CourseId);
                }
                if (!string.IsNullOrWhiteSpace(query.CourseIds))
                {
                    builder.AppendFormat(" AND {0} IN({1}) ", nameof(RB_Course_Notice_ViewModel.CourseId), query.CourseIds);
                }
            }

            return GetPage<RB_Course_Notice_ViewModel>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }
    }
}
