﻿using Edu.Model.ViewModel.Course;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Edu.Repository.Course
{
    /// <summary>
    /// 课程通知接收仓储层
    /// </summary>
    public class RB_Course_NoticeReviceRepository : BaseRepository<Model.Entity.Course.RB_Course_NoticeRevice>
    {
        /// <summary>
        /// 获取课程通知接收列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course_NoticeRevice_ViewModel> GetNoticeReviceListRepository(RB_Course_NoticeRevice_ViewModel query)
        {
            var parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM RB_Course_NoticeRevice
WHERE 1=1 
");
            if (query != null)
            {
                if (query.NoticeId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Course_NoticeRevice_ViewModel.NoticeId), query.NoticeId);
                }
                if (!string.IsNullOrWhiteSpace(query.NoticeIds))
                {
                    builder.AppendFormat(" AND {0} IN({1}) ", nameof(RB_Course_NoticeRevice_ViewModel.NoticeId), query.NoticeIds);
                }
            }
            return Get<RB_Course_NoticeRevice_ViewModel>(builder.ToString(), parameters).ToList();
        }
    }
}
