﻿using Edu.Model.ViewModel.Course;
using System.Linq;
using System.Text;

namespace Edu.Repository.Course
{
    /// <summary>
    /// 课程配置仓储层
    /// </summary>
    public class RB_Course_SettingRepository : BaseRepository<Model.Entity.Course.RB_Course_Setting>
    {
        /// <summary>
        /// 获取课程设置实体
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public RB_Course_Setting_ViewModel GetCourseSettingRepository(RB_Course_Setting_ViewModel query)
        {
            StringBuilder builder = new StringBuilder();
           builder.AppendFormat(@"
SELECT * 
FROM rb_course_setting
WHERE 1=1 
");
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_Course_Setting_ViewModel.Group_Id), query.Group_Id);
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_Course_Setting_ViewModel.School_Id), query.School_Id);
            if (query.SettingId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Course_Setting_ViewModel.SettingId), query.SettingId);
            }
            return Get<RB_Course_Setting_ViewModel>(builder.ToString()).FirstOrDefault();
        }
    }
}
