﻿using Edu.Model.ViewModel.Question;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Edu.Repository.Question
{
    /// <summary>
    /// 题库仓储层
    /// </summary>
    public class RB_QuestionRepository : BaseRepository<Model.Entity.Question.RB_Question>
    {
        /// <summary>
        /// 获取题库列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Question_ViewModel> GetQuestionListRepository(RB_Question_ViewModel query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM  RB_Question
WHERE 1=1 
");
            if (query == null)
            {
                return new List<RB_Question_ViewModel>();
            }
            else
            {
                if (query.CourseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Question_ViewModel.CourseId), query.CourseId);
                }
                return Get<RB_Question_ViewModel>(builder.ToString()).ToList();
            }
        }

        /// <summary>
        /// 获取题库分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Question_ViewModel> GetQuestionPageListRepository(int pageIndex, int pageSize, out long rowsCount, RB_Question_ViewModel query)
        {
            rowsCount = 0;
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM  RB_Question
WHERE 1=1 
");
            if (query == null)
            {
                return new List<RB_Question_ViewModel>();
            }
            else
            {
                if (query.CourseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Question_ViewModel.CourseId), query.CourseId);
                }
                return GetPage<RB_Question_ViewModel>(pageIndex,pageSize,out rowsCount,builder.ToString()).ToList();
            }
        }
    }
}