﻿using Edu.Common.Enum;
using Edu.Model.ViewModel.Question;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Edu.Repository.Question
{
    /// <summary>
    /// 题目知识点仓储层
    /// </summary>
    public class RB_Question_PointRepository : BaseRepository<Model.Entity.Question.RB_Question_Point>
    {
        /// <summary>
        /// 获取问题知识点列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Question_Point_ViewModel> GetPointListRepository(RB_Question_Point_ViewModel query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM RB_Question_Point
WHERE 1=1 
");
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_Question_Point_ViewModel.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (query.CourseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Question_Point_ViewModel.CourseId), query.CourseId);
                }
                if (query.QuestionId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Question_Point_ViewModel.CourseId), query.CourseId);
                }
            }
            return Get<RB_Question_Point_ViewModel>(builder.ToString()).ToList();
        }

        /// <summary>
        /// 获取知识点分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Question_Point_ViewModel> GetPointPageListRepository(int pageIndex, int pageSize, out long rowsCount, RB_Question_Point_ViewModel query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM RB_Question_Point
WHERE 1=1 
");
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_Question_Point_ViewModel.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (query.CourseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Question_Point_ViewModel.CourseId), query.CourseId);
                }
                if (query.QuestionId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Question_Point_ViewModel.CourseId), query.CourseId);
                }
            }
            return GetPage<RB_Question_Point_ViewModel>(pageIndex,pageSize,out rowsCount,builder.ToString()).ToList();
        }
    }
}