﻿using Edu.Common.Enum;
using Edu.Model.ViewModel.Question;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Edu.Repository.Question
{

    /// <summary>
    /// 题目类型仓储层
    /// </summary>
    public class RB_Question_TypeRepository : BaseRepository<Model.Entity.Question.RB_Question_Type>
    {
        /// <summary>
        /// 获取题目类型列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Question_Type_ViewModel> GetQuestionTypeListRepository(RB_Question_Type_ViewModel query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM  rb_question_type
WHERE 1=1 
");
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_Question_Type_ViewModel.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (query.QId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Question_Type_ViewModel.QId), query.QId);
                }
            }
            return Get<RB_Question_Type_ViewModel>(builder.ToString()).ToList();
        }
    }
}
