﻿using Edu.Common.Enum;
using Edu.Model.ViewModel.System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Edu.Repository.System
{
    public class RB_MenuRepository : BaseRepository<Model.Entity.System.RB_Menu>
    {
        /// <summary>
        /// 获取菜单列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Menu_ViewModel> GetMenuListRepository(RB_Menu_ViewModel query)
        {
            var parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM rb_menu
WHERE 1=1 
");
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_Menu_ViewModel.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (!string.IsNullOrWhiteSpace(query.MenuName))
                {
                    builder.AppendFormat(" AND {0} LIKE @MenuName ", nameof(RB_Menu_ViewModel.MenuName));
                    parameters.Add("MenuName", "%" + query.MenuName.Trim() + "%");
                }
                if (!string.IsNullOrWhiteSpace(query.MenuUrl))
                {
                    builder.AppendFormat(" AND {0} LIKE @MenuUrl ", nameof(RB_Menu_ViewModel.MenuUrl));
                    parameters.Add("MenuUrl", "%" + query.MenuUrl.Trim() + "%");
                }
                if (query.MenuLevel > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Menu_ViewModel.MenuLevel),query.MenuLevel);
                }
                if (query.MenuId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Menu_ViewModel.MenuLevel), query.MenuId);
                }
                if (query.ParentId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Menu_ViewModel.ParentId), query.ParentId);
                }
                if (query.MenuType > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Menu_ViewModel.MenuType), query.MenuType);
                }
            }
            return Get<RB_Menu_ViewModel>(builder.ToString(),parameters).ToList();
        }

        /// <summary>
        /// 获取菜单分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Menu_ViewModel> GetMenuPageListRepository(int pageIndex, int pageSize, out long rowsCount, RB_Menu_ViewModel query)
        {
            var parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM rb_menu
WHERE 1=1 
");
     
            if (query != null)
            {
                if (!string.IsNullOrWhiteSpace(query.MenuName))
                {
                    builder.AppendFormat(" AND {0} LIKE @MenuName ", nameof(RB_Menu_ViewModel.MenuName));
                    parameters.Add("MenuName", "%" + query.MenuName.Trim() + "%");
                }
                if (!string.IsNullOrWhiteSpace(query.MenuUrl))
                {
                    builder.AppendFormat(" AND {0} LIKE @MenuUrl ", nameof(RB_Menu_ViewModel.MenuUrl));
                    parameters.Add("MenuUrl", "%" + query.MenuUrl.Trim() + "%");
                }
                if (query.MenuLevel > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Menu_ViewModel.MenuLevel), query.MenuLevel);
                }
                if (query.MenuId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Menu_ViewModel.MenuLevel), query.MenuId);
                }
                if (query.ParentId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Menu_ViewModel.ParentId), query.ParentId);
                }
                if (query.MenuType > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Menu_ViewModel.MenuType), query.MenuType);
                }
                if ((int)query.Status > -1)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Menu_ViewModel.Status), (int)query.Status);
                }
            }
            return GetPage<RB_Menu_ViewModel>(pageIndex,pageSize,out rowsCount, builder.ToString(), parameters).ToList();
        }
    }
}