﻿using Edu.Common.Enum;
using Edu.Model.ViewModel.User;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Edu.Repository.User
{
    /// <summary>
    /// 助教仓储层
    /// </summary>
    public class RB_AssistRepository : BaseRepository<Model.Entity.User.RB_Assist>
    {
        /// <summary>
        /// 获取助教列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Assist_ViewModel> GetAssistListRepository(RB_Assist_ViewModel query)
        {
            var parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT a.*,g.GroupName,s.SName 
FROM rb_assist AS a LEFT JOIN rb_group AS g ON a.Group_Id=g.GId
     LEFT JOIN rb_school AS s ON a.School_Id=s.SId
WHERE 1=1 
");
            builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Assist_ViewModel.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (!string.IsNullOrWhiteSpace(query.AssistName))
                {
                    builder.AppendFormat(" AND a.{0} LIKE @AssistName ", nameof(RB_Assist_ViewModel.AssistName));
                    parameters.Add("AssistName", "%" + query.AssistName.Trim() + "%");
                }
                if (!string.IsNullOrWhiteSpace(query.AssistTel))
                {
                    builder.AppendFormat(" AND a.{0} LIKE @AssistTel ", nameof(RB_Assist_ViewModel.AssistTel));
                    parameters.Add("AssistTel", "%" + query.AssistTel.Trim() + "%");
                }
                if (!string.IsNullOrWhiteSpace(query.AssistIntro))
                {
                    builder.AppendFormat(" AND a.{0} LIKE @AssistIntro ", nameof(RB_Assist_ViewModel.AssistIntro));
                    parameters.Add("AssistIntro", "%" + query.AssistIntro.Trim() + "%");
                }
                if (query.AId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Assist_ViewModel.AId), query.AId);
                }
                if (query.School_Id > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Assist_ViewModel.School_Id), query.School_Id);
                }
                if (query.Group_Id > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Assist_ViewModel.Group_Id), query.Group_Id);
                }
                if (query.Teacher_Id > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Assist_ViewModel.Teacher_Id), query.Teacher_Id);
                }
            }
            return Get<RB_Assist_ViewModel>(builder.ToString()).ToList();
        }


        /// <summary>
        /// 获取助教分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Assist_ViewModel> GetAssistPageListRepository(int pageIndex,int pageSize,out long rowsCount,RB_Assist_ViewModel query)
        {
            var parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT a.*,g.GroupName,s.SName 
FROM rb_assist AS a LEFT JOIN rb_group AS g ON a.Group_Id=g.GId
     LEFT JOIN rb_school AS s ON a.School_Id=s.SId
WHERE 1=1 
");
            builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Assist_ViewModel.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (!string.IsNullOrWhiteSpace(query.AssistName))
                {
                    builder.AppendFormat(" AND a.{0} LIKE @AssistName ", nameof(RB_Assist_ViewModel.AssistName));
                    parameters.Add("AssistName", "%" + query.AssistName.Trim() + "%");
                }
                if (!string.IsNullOrWhiteSpace(query.AssistTel))
                {
                    builder.AppendFormat(" AND a.{0} LIKE @AssistTel ", nameof(RB_Assist_ViewModel.AssistTel));
                    parameters.Add("AssistTel", "%" + query.AssistTel.Trim() + "%");
                }
                if (!string.IsNullOrWhiteSpace(query.AssistIntro))
                {
                    builder.AppendFormat(" AND a.{0} LIKE @AssistIntro ", nameof(RB_Assist_ViewModel.AssistIntro));
                    parameters.Add("AssistIntro", "%" + query.AssistIntro.Trim() + "%");
                }
                if (query.AId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Assist_ViewModel.AId), query.AId);
                }
                if (query.School_Id > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Assist_ViewModel.School_Id), query.School_Id);
                }
                if (query.Group_Id > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Assist_ViewModel.Group_Id), query.Group_Id);
                }
                if (query.Teacher_Id > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Assist_ViewModel.Teacher_Id), query.Teacher_Id);
                }
            }
            return GetPage<RB_Assist_ViewModel>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }
    }
}
