﻿using Edu.Common.Enum;
using Edu.Model.ViewModel.User;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Edu.Repository.User
{
    /// <summary>
    /// 学校仓储层
    /// </summary>
    public class RB_SchoolRepository : BaseRepository<Model.Entity.User.RB_School>
    {
        /// <summary>
        /// 获取学校列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_School_ViewModel> GetSchoolListRepository(RB_School_ViewModel query)
        {
            var parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT s.*,g.GroupName 
FROM rb_school AS s LEFT JOIN rb_group AS g ON s.Group_Id=g.GId
WHERE 1=1 
");
            builder.AppendFormat(" AND s.{0}={1} ", nameof(RB_School_ViewModel.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (!string.IsNullOrWhiteSpace(query.SName))
                {
                    builder.AppendFormat(" AND s.{0} LIKE @SName ", nameof(RB_School_ViewModel.SName));
                    parameters.Add("SName", "%" + query.SName.Trim() + "%");
                }
                if (!string.IsNullOrWhiteSpace(query.SAddress))
                {
                    builder.AppendFormat(" AND s.{0} LIKE @SAddress ", nameof(RB_School_ViewModel.SAddress));
                    parameters.Add("SAddress", "%" + query.SAddress.Trim() + "%");
                }
                if (!string.IsNullOrWhiteSpace(query.SLinkMan))
                {
                    builder.AppendFormat(" AND s.{0} LIKE @SLinkMan ", nameof(RB_School_ViewModel.SLinkMan));
                    parameters.Add("SLinkMan", "%" + query.SLinkMan.Trim() + "%");
                }
                if (!string.IsNullOrWhiteSpace(query.SLinkTel))
                {
                    builder.AppendFormat(" AND s.{0} LIKE @SLinkTel ", nameof(RB_School_ViewModel.SLinkTel));
                    parameters.Add("SLinkTel", "%" + query.SLinkTel.Trim() + "%");
                }
                if (!string.IsNullOrWhiteSpace(query.SDomain))
                {
                    builder.AppendFormat(" AND s.{0} LIKE @SDomain ", nameof(RB_School_ViewModel.SDomain));
                    parameters.Add("SDomain", "%" + query.SDomain.Trim() + "%");
                }
                if (!string.IsNullOrWhiteSpace(query.Remark))
                {
                    builder.AppendFormat(" AND s.{0} LIKE @Remark ", nameof(RB_School_ViewModel.Remark));
                    parameters.Add("Remark", "%" + query.Remark.Trim() + "%");
                }
                if (query.SId > 0)
                {
                    builder.AppendFormat(" AND s.{0}={1} ", nameof(RB_School_ViewModel.SId), query.SId);
                }
                if (query.Group_Id > 0)
                {
                    builder.AppendFormat(" AND s.{0}={1} ", nameof(RB_School_ViewModel.Group_Id), query.Group_Id);
                }
            }
            return Get<RB_School_ViewModel>(builder.ToString(), parameters).ToList();
        }

        /// <summary>
        /// 获取学校分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_School_ViewModel> GetSchoolPageListRepository(int pageIndex, int pageSize, out long rowsCount, RB_School_ViewModel query)
        {
            var parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT s.*,g.GroupName 
FROM rb_school AS s LEFT JOIN rb_group AS g ON s.Group_Id=g.GId
WHERE 1=1 
");
            if (query != null)
            {
                if (!string.IsNullOrWhiteSpace(query.SName))
                {
                    builder.AppendFormat(" AND s.{0} LIKE @SName ", nameof(RB_School_ViewModel.SName));
                    parameters.Add("SName", "%" + query.SName.Trim() + "%");
                }
                if (!string.IsNullOrWhiteSpace(query.SAddress))
                {
                    builder.AppendFormat(" AND s.{0} LIKE @SAddress ", nameof(RB_School_ViewModel.SAddress));
                    parameters.Add("SAddress", "%" + query.SAddress.Trim() + "%");
                }
                if (!string.IsNullOrWhiteSpace(query.SLinkMan))
                {
                    builder.AppendFormat(" AND s.{0} LIKE @SLinkMan ", nameof(RB_School_ViewModel.SLinkMan));
                    parameters.Add("SLinkMan", "%" + query.SLinkMan.Trim() + "%");
                }
                if (!string.IsNullOrWhiteSpace(query.SLinkTel))
                {
                    builder.AppendFormat(" AND s.{0} LIKE @SLinkTel ", nameof(RB_School_ViewModel.SLinkTel));
                    parameters.Add("SLinkTel", "%" + query.SLinkTel.Trim() + "%");
                }
                if (!string.IsNullOrWhiteSpace(query.SDomain))
                {
                    builder.AppendFormat(" AND s.{0} LIKE @SDomain ", nameof(RB_School_ViewModel.SDomain));
                    parameters.Add("SDomain", "%" + query.SDomain.Trim() + "%");
                }
                if (!string.IsNullOrWhiteSpace(query.Remark))
                {
                    builder.AppendFormat(" AND s.{0} LIKE @Remark ", nameof(RB_School_ViewModel.Remark));
                    parameters.Add("Remark", "%" + query.Remark.Trim() + "%");
                }
                if (query.SId > 0)
                {
                    builder.AppendFormat(" AND s.{0}={1} ", nameof(RB_School_ViewModel.SId), query.SId);
                }
                if (query.Group_Id > 0)
                {
                    builder.AppendFormat(" AND s.{0}={1} ", nameof(RB_School_ViewModel.Group_Id), query.Group_Id);
                }
                if ((int)query.Status != -1)
                {
                    builder.AppendFormat(" AND s.{0}={1} ", nameof(RB_School_ViewModel.Status), (int)query.Status);
                }
            }
            builder.Append(" ORDER BY CreateTime DESC");
            return GetPage<RB_School_ViewModel>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }
    }
}