﻿using Edu.Common.Enum;
using Edu.Model.ViewModel.User;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Edu.Repository.User
{
    /// <summary>
    /// 学生仓储层
    /// </summary>
    public class RB_StudentRepository : BaseRepository<Model.Entity.User.RB_Student>
    {
        /// <summary>
        /// 获取学生列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Student_ViewModel> GetStudentListRepository(RB_Student_ViewModel query)
        {
            var parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT t.*,g.GroupName,s.SName 
FROM rb_student AS t LEFT JOIN rb_group AS g ON t.Group_Id=g.GId
     LEFT JOIN rb_school AS s ON t.School_Id=s.SId
WHERE 1=1 
");
            builder.AppendFormat(" AND t.{0}={1} ", nameof(RB_Student_ViewModel.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (query.Group_Id > 0)
                {
                    builder.AppendFormat(" AND t.{0}={1} ", nameof(RB_Student_ViewModel.Group_Id), query.Group_Id);
                }
                if (query.School_Id > 0)
                {
                    builder.AppendFormat(" AND t.{0}={1} ", nameof(RB_Student_ViewModel.School_Id), query.School_Id);
                }
                if (!string.IsNullOrWhiteSpace(query.StuName))
                {
                    builder.AppendFormat(" AND t.{0} LIKE @StuName ", nameof(RB_Student_ViewModel.StuName));
                    parameters.Add("StuName", "%" + query.StuName.Trim() + "%");
                }
                if (!string.IsNullOrWhiteSpace(query.StuTel))
                {
                    builder.AppendFormat(" AND t.{0} LIKE @StuTel ", nameof(RB_Student_ViewModel.StuTel));
                    parameters.Add("StuTel", "%" + query.StuTel.Trim() + "%");
                }
                if (query.ProviceId > 0)
                {
                    builder.AppendFormat(" AND t.{0}={1} ", nameof(RB_Student_ViewModel.ProviceId), query.ProviceId);
                }
                if (query.CityId > 0)
                {
                    builder.AppendFormat(" AND t.{0}={1} ", nameof(RB_Student_ViewModel.CityId), query.CityId);
                }
                if (query.AreaId > 0)
                {
                    builder.AppendFormat(" AND t.{0}={1} ", nameof(RB_Student_ViewModel.AreaId), query.AreaId);
                }
            }
            return Get<RB_Student_ViewModel>(builder.ToString(),parameters).ToList();
        }

        /// <summary>
        /// 获取学生分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Student_ViewModel> GetStudentPageListRepository(int pageIndex,int pageSize,out long rowsCount,RB_Student_ViewModel query)
        {
            var parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT t.*,g.GroupName,s.SName 
FROM rb_student AS t LEFT JOIN rb_group AS g ON t.Group_Id=g.GId
     LEFT JOIN rb_school AS s ON t.School_Id=s.SId
WHERE 1=1 
");
            if (query != null)
            {
                if (query.Status >= 0)
                {
                    builder.AppendFormat(" AND t.{0}={1} ", nameof(RB_Student_ViewModel.Status), (int)query.Status);
                }
                if (query.Group_Id > 0)
                {
                    builder.AppendFormat(" AND t.{0}={1} ", nameof(RB_Student_ViewModel.Group_Id), query.Group_Id);
                }
                if (query.School_Id > 0)
                {
                    builder.AppendFormat(" AND t.{0}={1} ", nameof(RB_Student_ViewModel.School_Id), query.School_Id);
                }
                if (!string.IsNullOrWhiteSpace(query.StuName))
                {
                    builder.AppendFormat(" AND t.{0} LIKE @StuName ", nameof(RB_Student_ViewModel.StuName));
                    parameters.Add("StuName", "%" + query.StuName.Trim() + "%");
                }
                if (!string.IsNullOrWhiteSpace(query.StuTel))
                {
                    builder.AppendFormat(" AND t.{0} LIKE @StuTel ", nameof(RB_Student_ViewModel.StuTel));
                    parameters.Add("StuTel", "%" + query.StuTel.Trim() + "%");
                }
                if (query.ProviceId > 0)
                {
                    builder.AppendFormat(" AND t.{0}={1} ", nameof(RB_Student_ViewModel.ProviceId), query.ProviceId);
                }
                if (query.CityId > 0)
                {
                    builder.AppendFormat(" AND t.{0}={1} ", nameof(RB_Student_ViewModel.CityId), query.CityId);
                }
                if (query.AreaId > 0)
                {
                    builder.AppendFormat(" AND t.{0}={1} ", nameof(RB_Student_ViewModel.AreaId), query.AreaId);
                }
            }
            return GetPage<RB_Student_ViewModel>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }
    }
}