﻿using System;
using Edu.Cache.User;
using Edu.Common.API;
using Edu.Common.Plugin;
using Edu.Model.ViewModel.Course;
using Edu.Module.Course;
using Edu.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;

namespace Edu.WebApi.Controllers.Course
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class CourseController : BaseController
    {
        /// <summary>
        /// 课程分类处理类
        /// </summary>
        private readonly CourseCategoryModule categoryModule = new CourseCategoryModule();

        /// <summary>
        /// 课程处理类对象
        /// </summary>
        private readonly CourseModule courseModule = new CourseModule();

        #region 课程分类管理
        /// <summary>
        /// 获取课程分类分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetCourseCategoryPageList()
        {
            var pageModel = Common.Plugin.JsonHelper.DeserializeObject<ResultPageModel>(RequestParm.Msg.ToString());
            var query = Common.Plugin.JsonHelper.DeserializeObject<RB_Course_Category_ViewModel>(RequestParm.Msg.ToString());
            query.Group_Id = base.UserInfo.Group_Id;
            query.School_Id = base.UserInfo.School_Id;
            var list = categoryModule.GetCourseCategoryPageListModule(pageModel.PageIndex, pageModel.PageSize, out long rowsCount, query);
            foreach (var item in list)
            {
                if (item.CreateBy > 0)
                {
                    item.CreateByName = UserReidsCache.GetUserLoginInfo(item.CreateBy)?.AccountName ?? "";
                }
                if (item.UpdateBy > 0)
                {
                    item.UpdateByName = UserReidsCache.GetUserLoginInfo(item.UpdateBy)?.AccountName ?? "";
                }
            }
            pageModel.Count = rowsCount;
            pageModel.PageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取课程分类列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetCourseCategoryList()
        {
            var query = Common.Plugin.JsonHelper.DeserializeObject<RB_Course_Category_ViewModel>(RequestParm.Msg.ToString());
            query.Group_Id = base.UserInfo.Group_Id;
            query.School_Id = base.UserInfo.School_Id;
            var list = categoryModule.GetCourseCategoryListModule(query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 获取课程分类树形列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetChildCategoryList()
        {
            var query = Common.Plugin.JsonHelper.DeserializeObject<RB_Course_Category_ViewModel>(RequestParm.Msg.ToString());
            query.Group_Id = base.UserInfo.Group_Id;
            query.School_Id = base.UserInfo.School_Id;
            var cateIds= base.ParmJObj.GetStringValue("cateIds");
            var list = categoryModule.GetChildCategoryStringModule(cateIds);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 获取课程分类树形列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetCourseCategoryTree()
        {
            var query = Common.Plugin.JsonHelper.DeserializeObject<RB_Course_Category_ViewModel>(RequestParm.Msg.ToString());
            query.Group_Id = base.UserInfo.Group_Id;
            query.School_Id = base.UserInfo.School_Id;
            var list = categoryModule.GetCourseCategoryTreeListModule(query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 添加修改课程分类
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetCourseCategory()
        {
            var extModel = Common.Plugin.JsonHelper.DeserializeObject<RB_Course_Category_ViewModel>(RequestParm.Msg.ToString());
            extModel.CreateTime = DateTime.Now;
            extModel.CreateBy = base.UserInfo.Id;
            extModel.UpdateBy = base.UserInfo.Id;
            extModel.UpdateTime = DateTime.Now;
            extModel.Group_Id = this.UserInfo.Group_Id;
            extModel.School_Id = this.UserInfo.School_Id;
            bool flag = categoryModule.SetCourseCategoryModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取课程分类
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetCourseCategory()
        {
            var CateId = base.ParmJObj.GetInt("CateId", 0);
            var extModel = categoryModule.GetCourseCategoryModule(CateId);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除课程分类
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult RemoveCourseCategory()
        {
            var CateId = base.ParmJObj.GetInt("CateId", 0);
            var flag = categoryModule.RemoveCourseCategoryModule(CateId);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion

        #region 课程管理

        /// <summary>
        /// 获取课程分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetCoursePageList()
        {
            var pageModel = Common.Plugin.JsonHelper.DeserializeObject<ResultPageModel>(RequestParm.Msg.ToString());
            var query = Common.Plugin.JsonHelper.DeserializeObject<RB_Course_ViewModel>(RequestParm.Msg.ToString());
            query.Group_Id = base.UserInfo.Group_Id;
            query.School_Id = base.UserInfo.School_Id;
            var list = courseModule.GetCoursePageListModule(pageModel.PageIndex, pageModel.PageSize, out long rowsCount, query);
            foreach (var item in list)
            {
                if (item.CreateBy > 0)
                {
                    item.CreateByName = UserReidsCache.GetUserLoginInfo(item.CreateBy)?.AccountName ?? "";
                }
                if (item.UpdateBy > 0)
                {
                    item.UpdateByName = UserReidsCache.GetUserLoginInfo(item.UpdateBy)?.AccountName ?? "";
                }
            }
            pageModel.Count = rowsCount;
            pageModel.PageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取课程列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetCourseList()
        {
            var query = Common.Plugin.JsonHelper.DeserializeObject<RB_Course_ViewModel>(RequestParm.Msg.ToString());
            query.Group_Id = base.UserInfo.Group_Id;
            query.School_Id = base.UserInfo.School_Id;
            var list = courseModule.GetCourseListModule(query);
            return ApiResult.Success(data: list);
        }
         

        /// <summary>
        /// 添加修改课程
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetCourse()
        {
            var extModel = Common.Plugin.JsonHelper.DeserializeObject<RB_Course_ViewModel>(RequestParm.Msg.ToString());
            extModel.CreateTime = DateTime.Now;
            extModel.CreateBy = base.UserInfo.Id;
            extModel.UpdateBy = base.UserInfo.Id;
            extModel.UpdateTime = DateTime.Now;
            extModel.Group_Id = this.UserInfo.Group_Id;
            extModel.School_Id = this.UserInfo.School_Id;
            bool flag = courseModule.SetCourseModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取课程
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetCourse()
        {
            var CourseId = base.ParmJObj.GetInt("CourseId", 0);
            var extModel = courseModule.GetCourseModule(CourseId);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除课程
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult RemoveCourse()
        {
            var CourseId = base.ParmJObj.GetInt("CourseId", 0);
            var flag = courseModule.RemoveCourseModule(CourseId);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 是否显示章节编号
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetCourseIsShowChapterNo()
        {
            var CourseId = base.ParmJObj.GetInt("CourseId", 0);
            int IsShowChapterNo = base.ParmJObj.GetInt("IsShowChapterNo", 0);
            var flag = courseModule.SetCourseIsShowChapterNoModule(CourseId, IsShowChapterNo);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 设置课程教师
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetCourseTeacher()
        {
            var CourseId = base.ParmJObj.GetInt("CourseId", 0);
            int Teacher_Id = base.ParmJObj.GetInt("Teacher_Id", 0);
            var flag = courseModule.SetCourseTeacherModule(CourseId, Teacher_Id);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion

        #region 教案管理

        /// <summary>
        /// 获取课程教案分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetCourseTeachPlanPage()
        {
            var pageModel = Common.Plugin.JsonHelper.DeserializeObject<ResultPageModel>(RequestParm.Msg.ToString());
            var query = Common.Plugin.JsonHelper.DeserializeObject<RB_Course_TeachPlan_ViewModel>(RequestParm.Msg.ToString());
            query.Group_Id = base.UserInfo.Group_Id;
            query.School_Id = base.UserInfo.School_Id;
            var list = courseModule.GetCourseTeachPlanPageListModule(pageModel.PageIndex, pageModel.PageSize, out long rowsCount, query);
            foreach (var item in list)
            {
                if (item.CreateBy > 0)
                {
                    item.CreateByName = UserReidsCache.GetUserLoginInfo(item.CreateBy)?.AccountName ?? "";
                }
                if (item.UpdateBy > 0)
                {
                    item.UpdateByName = UserReidsCache.GetUserLoginInfo(item.UpdateBy)?.AccountName ?? "";
                }
            }
            pageModel.Count = rowsCount;
            pageModel.PageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 添加修改课程教案
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetTeachPlan()
        {
            var extModel = Common.Plugin.JsonHelper.DeserializeObject<RB_Course_TeachPlan_ViewModel>(RequestParm.Msg.ToString());
            extModel.CreateTime = DateTime.Now;
            extModel.CreateBy = base.UserInfo.Id;
            extModel.UpdateBy = base.UserInfo.Id;
            extModel.UpdateTime = DateTime.Now;
            extModel.Group_Id = this.UserInfo.Group_Id;
            extModel.School_Id = this.UserInfo.School_Id;
            bool flag = courseModule.SetTeachPlanModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取课程教案
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetTeachPlan()
        {
            var PlanId = base.ParmJObj.GetInt("PlanId", 0);
            var extModel = courseModule.GetTeachPlanModule(PlanId);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除课程教案
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult RemoveTeachPlan()
        {
            var PlanId = base.ParmJObj.GetInt("PlanId", 0);
            var flag = courseModule.RemoveTeachPlanModule(PlanId);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        #endregion

        #region 课程章节管理

        /// <summary>
        /// 添加修改课程章节
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetChapter()
        {
            var extModel = Common.Plugin.JsonHelper.DeserializeObject<RB_Course_Chapter_ViewModel>(RequestParm.Msg.ToString());
            extModel.CreateTime = DateTime.Now;
            extModel.CreateBy = base.UserInfo.Id;
            extModel.UpdateBy = base.UserInfo.Id;
            extModel.UpdateTime = DateTime.Now;
            extModel.Group_Id = this.UserInfo.Group_Id;
            extModel.School_Id = this.UserInfo.School_Id;
            bool flag = courseModule.SetChapterModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取课程章节列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetChapterList()
        {
            var query = Common.Plugin.JsonHelper.DeserializeObject<RB_Course_Chapter_ViewModel>(RequestParm.Msg.ToString());
            query.Group_Id = base.UserInfo.Group_Id;
            query.School_Id = base.UserInfo.School_Id;
            var list = courseModule.GetChapterListModule(query);
            return ApiResult.Success(data: list);
        }

        
        #endregion
    }
}
