﻿using Edu.Cache.User;
using Edu.Common.API;
using Edu.Common.Plugin;
using Edu.Model.ViewModel.Question;
using Edu.Module.Question;
using Edu.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using System;

namespace Edu.WebApi.Controllers.Course
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class QuestionController : BaseController
    {
        /// <summary>
        /// 题库处理类对象
        /// </summary>
        private readonly QuestionModule questionModule = new QuestionModule();

        #region 题库管理

        /// <summary>
        /// 获取题目类型列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetQuestionTypeList()
        {
            var query = Common.Plugin.JsonHelper.DeserializeObject<RB_Question_Type_ViewModel>(RequestParm.Msg.ToString());
            var list = questionModule.GetQuestionTypeListModule(query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 获取课程问题分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetQuestionPageList()
        {
            var pageModel = Common.Plugin.JsonHelper.DeserializeObject<ResultPageModel>(RequestParm.Msg.ToString());
            var query = Common.Plugin.JsonHelper.DeserializeObject<RB_Question_ViewModel>(RequestParm.Msg.ToString());
            var list = questionModule.GetQuestionPageListModule(pageModel.PageIndex, pageModel.PageSize, out long rowsCount, query);
            foreach (var item in list)
            {
                if (item.CreateBy > 0)
                {
                    item.CreateByName = UserReidsCache.GetUserLoginInfo(item.CreateBy)?.AccountName ?? "";
                }
                if (item.UpdateBy > 0)
                {
                    item.UpdateByName = UserReidsCache.GetUserLoginInfo(item.UpdateBy)?.AccountName ?? "";
                }
            }
            pageModel.Count = rowsCount;
            pageModel.PageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取课程问题列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetQuestionList()
        {
            var query = Common.Plugin.JsonHelper.DeserializeObject<RB_Question_ViewModel>(RequestParm.Msg.ToString());
            var list = questionModule.GetQuestionListModule(query);
            return ApiResult.Success(data: list);
        }

  
        /// <summary>
        /// 添加修改问题
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetQuestion()
        {
            var extModel = Common.Plugin.JsonHelper.DeserializeObject<RB_Question_ViewModel>(RequestParm.Msg.ToString());
            extModel.CreateTime = DateTime.Now;
            extModel.CreateBy = base.UserInfo.Id;
            extModel.UpdateBy = base.UserInfo.Id;
            extModel.UpdateTime = DateTime.Now;
            bool flag = questionModule.SetQuestionModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取课程问题
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetQuestion()
        {
            var QuestionId = base.ParmJObj.GetInt("QuestionId", 0);
            var extModel = questionModule.GetQuestionModule(QuestionId);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除课程问题
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult RemoveCourseCategory()
        {
            var QuestionId = base.ParmJObj.GetInt("QuestionId", 0);
            var flag = questionModule.RemoveQuestionModule(QuestionId);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion
    }
}
