﻿using System;
using Edu.Common.API;
using Edu.Common.Plugin;
using Edu.Model.ViewModel.System;
using Edu.Module.System;
using Edu.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;

namespace Edu.WebApi.Controllers.Public
{
    /// <summary>
    /// 系统公用接口
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class PublicController : BaseController
    {
        /// <summary>
        /// 省市区处理类对象
        /// </summary>
        private readonly DestinationModule destinationModule = new DestinationModule();

        /// <summary>
        /// 菜单处理类对象
        /// </summary>
        private readonly MenuModule menuModule = new MenuModule();

        /// <summary>
        /// 角色处理类对象
        /// </summary>
        private readonly RoleModule roleModule = new RoleModule();

        #region 省市区

        /// <summary>
        /// 获取省市区树形列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetAreaTree()
        {
            var list = destinationModule.GetAreaTree();
            return ApiResult.Success(data: list);
        }

        #endregion 

        #region 菜单管理
        /// <summary>
        /// 获取菜单分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMenuPageList()
        {
            var pageModel = Common.Plugin.JsonHelper.DeserializeObject<ResultPageModel>(RequestParm.Msg.ToString());
            var query = Common.Plugin.JsonHelper.DeserializeObject<RB_Menu_ViewModel>(RequestParm.Msg.ToString());
            var list = menuModule.GetMenuPageListModule(pageModel.PageIndex, pageModel.PageSize, out long rowsCount, query);
            pageModel.Count = rowsCount;
            pageModel.PageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取菜单列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMenuList()
        {
            var query = Common.Plugin.JsonHelper.DeserializeObject<RB_Menu_ViewModel>(RequestParm.Msg.ToString());
            var list = menuModule.GetMenuListModule(query);
            return ApiResult.Success(data: list);
        }


        /// <summary>
        /// 获取树形菜单列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetTreeMenu()
        {
            var query = Common.Plugin.JsonHelper.DeserializeObject<RB_Menu_ViewModel>(RequestParm.Msg.ToString());
            var list = menuModule.GetTreeMenuModule(query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 添加修改菜单
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetMenu()
        {
            var extModel = Common.Plugin.JsonHelper.DeserializeObject<RB_Menu_ViewModel>(RequestParm.Msg.ToString());
            extModel.CreateTime = DateTime.Now;
            bool flag = menuModule.SetMenuModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取菜单实体
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMenu()
        {
            var MenuId = base.ParmJObj.GetInt("MenuId", 0);
            var extModel = menuModule.GetMenuModule(MenuId);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 修改菜单状态
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetMenuStatus()
        {
            var MenuId = base.ParmJObj.GetInt("MenuId", 0);
            int Status = base.ParmJObj.GetInt("Status", 0);
            var flag = menuModule.SetMenuStatusModule(MenuId, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion

        #region 角色管理
        /// <summary>
        /// 获取角色分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetRolePageList()
        {
            var pageModel = Common.Plugin.JsonHelper.DeserializeObject<ResultPageModel>(RequestParm.Msg.ToString());
            var query = Common.Plugin.JsonHelper.DeserializeObject<RB_Role_ViewModel>(RequestParm.Msg.ToString());
            var list = roleModule.GetRolePageListModule(pageModel.PageIndex, pageModel.PageSize, out long rowsCount, query);
            pageModel.Count = rowsCount;
            pageModel.PageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取角色列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetRoleList()
        {
            var query = Common.Plugin.JsonHelper.DeserializeObject<RB_Role_ViewModel>(RequestParm.Msg.ToString());
            var list = roleModule.GetRoleListModule(query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 添加修改角色
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetRole()
        {
            var extModel = Common.Plugin.JsonHelper.DeserializeObject<RB_Role_ViewModel>(RequestParm.Msg.ToString());
            extModel.CreateDate = DateTime.Now;
            extModel.CreateBy = base.UserInfo.Id;
            extModel.Group_Id = base.UserInfo.Group_Id;
            extModel.School_Id = base.UserInfo.School_Id;
            bool flag = roleModule.SetRoleModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取角色实体
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetRole()
        {
            var RoleId = base.ParmJObj.GetInt("RoleId", 0);
            var extModel = roleModule.GetRoleModule(RoleId);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除角色
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult RemoveRole()
        {
            var RoleId = base.ParmJObj.GetInt("RoleId", 0);
            var flag = roleModule.RemoveRoleModule(RoleId);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion
    }
}