using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Hosting;
using Microsoft.Extensions.Hosting;

namespace Edu.WebApi
{
    public class Program
    {
        public static void Main(string[] args)
        {
            CreateHostBuilder(args).Build().Run();
        }

        public static IHostBuilder CreateHostBuilder(string[] args) =>
            Host.CreateDefaultBuilder(args)
                .ConfigureWebHostDefaults(webBuilder =>
                {
                    webBuilder.ConfigureKestrel((context, options) =>
                    {
                        options.AllowSynchronousIO = true;
                        //Ӧ÷KestrelΪ50MB
                        options.Limits.MaxRequestBodySize = 52428800;
                        //쳣
                        options.Limits.MinRequestBodyDataRate = null;
                    });
                    webBuilder.UseStartup<Startup>().UseIIS();
                });
    }
}