using System.Collections.Generic;
using System.Text.Encodings.Web;
using System.Text.Unicode;
using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Hosting;

namespace Edu.WebApi
{
    public class Startup
    {
        public Startup(IConfiguration configuration)
        {
            Configuration = configuration;
        }

        public IConfiguration Configuration { get; }

        // This method gets called by the runtime. Use this method to add services to the container.
        public void ConfigureServices(IServiceCollection services)
        {
            services.Configure<Microsoft.AspNetCore.Server.Kestrel.Core.KestrelServerOptions>(x => x.AllowSynchronousIO = true)
                .Configure<IISServerOptions>(x => x.AllowSynchronousIO = true);
            services.AddControllers();
            services.AddSingleton<IHttpContextAccessor, HttpContextAccessor>(); //עhttp
            services.AddMvc().AddJsonOptions(options =>
            {
                options.JsonSerializerOptions.Encoder = JavaScriptEncoder.Create(UnicodeRanges.All);
                options.JsonSerializerOptions.PropertyNamingPolicy = null;
            });
            List<string> corsArray = new List<string>()
            {
                "http://localhost:8081",
                "http://localhost:8080",
                "http://localhost:8082",
                "http://127.0.0.1:50512",
                "http://127.0.0.1:20224",
                "http://127.0.0.1:28221",
                "http://www.test.com:8080",
                "http://www.test.com:8081",
                "http://yx.oytour.com",
                "http://mall.oytour.com",
                "http://testmall.oytour.com",
                "http://yx.oytour.com",
            };
            services.AddCors(options => options.AddPolicy("AllowCors", policy => policy.AllowAnyHeader().AllowAnyMethod().AllowCredentials().WithOrigins(corsArray.ToArray())));
        }
 

        // This method gets called by the runtime. Use this method to configure the HTTP request pipeline.
        public void Configure(IApplicationBuilder app, IWebHostEnvironment env, IHostApplicationLifetime appLifetime)
        {
            if (env.IsDevelopment())
            {
                app.UseDeveloperExceptionPage();
            }

            app.UseHttpsRedirection();

            app.UseRouting();
            // пcorsConfigureServicesõĿ
            app.UseCors("AllowCors");

            app.UseAuthorization();

            app.UseEndpoints(endpoints =>
            {
                endpoints.MapControllers();
            });
        }
    }
}