﻿using Newtonsoft.Json.Converters;
 

namespace Edu.Common.Plugin
{
    /// <summary>
    /// 格式化时间【yyyy-MM-dd HH:mm:ss】
    /// </summary>
    public class DateConvert : IsoDateTimeConverter
    {
        /// <summary>
        /// 格式化时间
        /// </summary>
        public DateConvert()
        {
            base.DateTimeFormat = "yyyy-MM-dd HH:mm:ss";
        }
    }

    /// <summary>
    /// 格式化日期【yyyy-MM-dd】
    /// </summary>
    public class DateConvertTwo : IsoDateTimeConverter
    {
        /// <summary>
        /// 格式化时间
        /// </summary>
        public DateConvertTwo()
        {
            base.DateTimeFormat = "yyyy-MM-dd";
        }
    }
}
