﻿using Edu.Common.Enum;
using System;
using VT.FW.DB;

namespace Edu.Model.Entity.Course
{
    /// <summary>
    /// 课程实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Course
    {
		/// <summary>
		/// 主键(课程编号)
		/// </summary>
		public int CourseId { get; set; }

		/// <summary>
		/// 课程封面图
		/// </summary>
		public string CoverImg { get; set; }

		/// <summary>
		/// 课程名称
		/// </summary>
		public string CourseName { get; set; }

		/// <summary>
		/// 课程介绍
		/// </summary>
		public string CourseIntro { get; set; }

		/// <summary>
		/// 课程分类编号
		/// </summary>
		public int CateId { get; set; }

		/// <summary>
		/// 创建人
		/// </summary>
		public int CreateBy { get; set; }

		/// <summary>
		/// 创建时间
		/// </summary>
		public DateTime CreateTime { get; set; }

		/// <summary>
		/// 修改人
		/// </summary>
		public int UpdateBy { get; set; }

		/// <summary>
		/// 更新时间
		/// </summary>
		public DateTime UpdateTime { get; set; }

		/// <summary>
		/// 学校Id
		/// </summary>
		public int School_Id { get; set; }

		/// <summary>
		/// 集团编号
		/// </summary>
		public int Group_Id { get; set; }

		/// <summary>
		/// 删除状态
		/// </summary>
		public DateStateEnum Status { get; set; }

		/// <summary>
		/// 教师编号
		/// </summary>
		public int Teacher_Id { get; set; }

		/// <summary>
		/// 是否显示章节编号
		/// </summary>
		public int IsShowChapterNo { get; set; }
	}
}