﻿using Edu.Common.Enum;
using System;
using VT.FW.DB;

namespace Edu.Model.Entity.Course
{
    /// <summary>
    /// 课程章节实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Course_Chapter
    {
		/// <summary>
		/// 主键(章节编号)
		/// </summary>
		public int ChapterId { get; set; }

		/// <summary>
		/// 课程Id
		/// </summary>
		public int CourseId { get; set; }

		/// <summary>
		/// 章节编号
		/// </summary>
		public string ChapterNo { get; set; }

		/// <summary>
		/// 章节名称
		/// </summary>
		public string ChapterName { get; set; }

		/// <summary>
		/// 章节内容
		/// </summary>
		public string ChapterContent { get; set; }

		/// <summary>
		/// 父节点编号
		/// </summary>
		public int ParentId { get; set; }

		/// <summary>
		/// 开发状态(1-开放，2-定时开放)
		/// </summary>
		public int OpenStatus { get; set; }

		/// <summary>
		/// 章节进度
		/// </summary>
		public int Progress { get; set; }

		/// <summary>
		/// 创建人
		/// </summary>
		public int CreateBy { get; set; }

		/// <summary>
		/// 创建时间
		/// </summary>
		public DateTime CreateTime { get; set; }

		/// <summary>
		/// 修改人
		/// </summary>
		public int UpdateBy { get; set; }

		/// <summary>
		/// 更新时间
		/// </summary>
		public DateTime UpdateTime { get; set; }

		/// <summary>
		/// 删除状态
		/// </summary>
		public DateStateEnum Status { get; set; }

		/// <summary>
		/// 开放开始时间
		/// </summary>
		public DateTime? OpenStart { get; set; }

		/// <summary>
		/// 开放结束时间
		/// </summary>
		public DateTime? OpenEnd { get; set; }

		/// <summary>
		/// 学校编号
		/// </summary>
		public int School_Id { get; set; }

		/// <summary>
		/// 集团编号
		/// </summary>
		public int Group_Id { get; set; }
	}
}
