﻿using Edu.Common.Enum;
using System;
using VT.FW.DB;

namespace Edu.Model.Entity.Course
{
    /// <summary>
    /// 课程通知实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Course_Notice
    {
		/// <summary>
		/// 主键（通知编号）
		/// </summary>
		public int NoticeId { get; set; }

		/// <summary>
		/// CourseId
		/// </summary>
		public int CourseId { get; set; }

		/// <summary>
		/// 通知标题
		/// </summary>
		public string Title { get; set; }

		/// <summary>
		/// 通知内容
		/// </summary>
		public string Content { get; set; }

		/// <summary>
		/// 是否置顶(1-是)
		/// </summary>
		public int IsTop { get; set; }

		/// <summary>
		/// 发布状态(0-默认，1-已发布，2-撤回）
		/// </summary>
		public int PublishStatus { get; set; }

		/// <summary>
		/// 删除状态
		/// </summary>
		public DateStateEnum Status { get; set; }

		/// <summary>
		/// 创建人
		/// </summary>
		public int CreateBy { get; set; }

		/// <summary>
		/// 创建时间
		/// </summary>
		public DateTime CreateTime { get; set; }

		/// <summary>
		/// 修改人
		/// </summary>
		public int UpdateBy { get; set; }

		/// <summary>
		/// 更新时间
		/// </summary>
		public DateTime UpdateTime { get; set; }


		/// <summary>
		/// 学校编号
		/// </summary>
		public int School_Id { get; set; }

		/// <summary>
		/// 集团编号
		/// </summary>
		public int Group_Id { get; set; }

	}
}
