﻿using System;
using VT.FW.DB;

namespace Edu.Model.Entity.Course
{
    /// <summary>
    /// 课程资料实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Course_Source
    {
		/// <summary>
		/// 主键(资料编号)
		/// </summary>
		public int SourceId { get; set; }

		/// <summary>
		/// 课程编号
		/// </summary>
		public int CourseId { get; set; }

		/// <summary>
		/// 资料名称
		/// </summary>
		public string SourceName { get; set; }

		/// <summary>
		/// 资料类型
		/// </summary>
		public int SourceType { get; set; }

		/// <summary>
		/// 资料URL
		/// </summary>
		public string SourceUrl { get; set; }

		/// <summary>
		/// 阅读次数
		/// </summary>
		public int ReadCount { get; set; }

		/// <summary>
		/// 下载次数
		/// </summary>
		public int DownLoadCount { get; set; }

		/// <summary>
		/// 资料大小
		/// </summary>
		public decimal SourceSize { get; set; }

		/// <summary>
		/// 父级资料编号
		/// </summary>
		public int ParentSourceId { get; set; }

		/// <summary>
		/// 创建人
		/// </summary>
		public int CreateBy { get; set; }

		/// <summary>
		/// 创建时间
		/// </summary>
		public DateTime CreateTime { get; set; }

		/// <summary>
		/// 修改人
		/// </summary>
		public int UpdateBy { get; set; }

		/// <summary>
		/// 更新时间
		/// </summary>
		public DateTime UpdateTime { get; set; }

		/// <summary>
		/// 共享类型(0-私有)
		/// </summary>
		public int ShareType { get; set; }

		/// <summary>
		/// 学校Id
		/// </summary>
		public int School_Id { get; set; }

		/// <summary>
		/// 集团编号
		/// </summary>
		public int Group_Id { get; set; }

	}
}