﻿using Edu.Common.Enum;
using System;
using VT.FW.DB;

namespace Edu.Model.Entity.System
{
    /// <summary>
    /// 地区实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Destination
    {
		/// <summary>
		/// 主键编号
		/// </summary>
		public int ID { get; set; }

		/// <summary>
		/// 名称
		/// </summary>
		public string Name { get; set; }

		/// <summary>
		/// 父级编号
		/// </summary>
		public int ParentID { get; set; }

		/// <summary>
		/// 等级(1-国家，2-省份，3-城市，4-区县)
		/// </summary>
		public int CodeLevel { get; set; }

		/// <summary>
		/// 状态
		/// </summary>
		public DateStateEnum Status { get; set; }
	}
}
