﻿using Edu.Common.Enum;
using System;
using VT.FW.DB;

namespace Edu.Model.Entity.System
{
    /// <summary>
    /// 系统角色实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Role
    {
		/// <summary>
		/// 角色编号
		/// </summary>
		public int RoleId { get; set; }

		/// <summary>
		/// 角色名称
		/// </summary>
		public string RoleName { get; set; }

		/// <summary>
		/// 备注/描述
		/// </summary>
		public string RoleIntro { get; set; }

		/// <summary>
		/// 角色权限
		/// </summary>
		public string RoleAuth { get; set; }

		/// <summary>
		/// 状态(0-正常,1-删除)
		/// </summary>
		public DateStateEnum Status { get; set; }

		/// <summary>
		/// 创建时间
		/// </summary>
		public DateTime CreateDate { get; set; }

		/// <summary>
		/// 创建人
		/// </summary>
		public int CreateBy { get; set; }

		/// <summary>
		/// 集团编号
		/// </summary>
		public int Group_Id { get; set; }

		/// <summary>
		/// 学校Id
		/// </summary>
		public int School_Id { get; set; }
	}
}