﻿using Edu.Common.Enum;
using Edu.Common.Enum.User;
using System;
using VT.FW.DB;

namespace Edu.Model.Entity.User
{
	/// <summary>
	/// 助教实体类
	/// </summary>
	[Serializable]
	[DB(ConnectionName = "DefaultConnection")]
	public  class RB_Assist
    {
		/// <summary>
		/// 主键(助教编号)
		/// </summary>
 
		public int AId { get; set; }

		/// <summary>
		/// 学校编号
		/// </summary>
		public int School_Id { get; set; }

		/// <summary>
		/// 教师编号
		/// </summary>
		public int Teacher_Id { get; set; }

		/// <summary>
		/// 助教名称
		/// </summary>
		public string AssistName { get; set; }

		/// <summary>
		/// 助教电话
		/// </summary>
		public string AssistTel { get; set; }

		/// <summary>
		/// 助教头像
		/// </summary>
		public string AssistIcon { get; set; }

		/// <summary>
		/// 助教简介
		/// </summary>
		public string AssistIntro { get; set; }

		/// <summary>
		/// 审核状态(1-审核中,2-审核通过,3-审核不通过)
		/// </summary>
		public AccountStatusEnum AuditStatus { get; set; }

		/// <summary>
		/// 删除状态(1-删除)
		/// </summary>
		public DateStateEnum Status { get; set; }

		/// <summary>
		/// 审核备注
		/// </summary>
		public string Remark { get; set; }

		/// <summary>
		/// 创建人
		/// </summary>
		public int CreateBy { get; set; }

		/// <summary>
		/// 创建时间
		/// </summary>
		public DateTime CreateTime { get; set; }

		/// <summary>
		/// 修改人
		/// </summary>
		public int UpdateBy { get; set; }

		/// <summary>
		/// 更新时间
		/// </summary>
		public DateTime UpdateTime { get; set; }

		/// <summary>
		/// 集团编号
		/// </summary>
		public int Group_Id { get; set; }
	}
}