﻿using Edu.Common.Enum;
using System;
using VT.FW.DB;

namespace Edu.Model.Entity.User
{
    /// <summary>
    /// 管理者实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Manager
    {
		/// <summary>
		/// 主键(管理者编号)
		/// </summary>
		public int MId { get; set; }

		/// <summary>
		/// 管理者姓名
		/// </summary>
		public string MName { get; set; }

		/// <summary>
		/// 讲师手机号码
		/// </summary>
		public string MTel { get; set; }

		/// <summary>
		/// 讲师头像
		/// </summary>
		public string MHead { get; set; }

		/// <summary>
		/// 创建人
		/// </summary>
		public int CreateBy { get; set; }

		/// <summary>
		/// 创建时间
		/// </summary>
		public DateTime CreateTime { get; set; }

		/// <summary>
		/// 修改人
		/// </summary>
		public int UpdateBy { get; set; }

		/// <summary>
		/// 更新时间
		/// </summary>
		public DateTime UpdateTime { get; set; }

		/// <summary>
		/// 集团编号
		/// </summary>
		public int Group_Id { get; set; }

		/// <summary>
		/// 学校编号
		/// </summary>
		public int School_Id { get; set; }

		/// <summary>
		/// 删除状态
		/// </summary>
		public DateStateEnum Status { get; set; }

	}
}
