﻿using Edu.Common.Enum;
using System;
using VT.FW.DB;

namespace Edu.Model.Entity.User
{
    /// <summary>
    /// 学生实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Student
    {
        /// <summary>
        /// 主键(学生编号)
        /// </summary>

        public int StuId { get; set; }

        /// <summary>
        /// 学生昵称
        /// </summary>
        public string StuName { get; set; }

        /// <summary>
        /// 学生电话
        /// </summary>
        public string StuTel { get; set; }

        /// <summary>
        /// 学生头像
        /// </summary>
        public string StuIcon { get; set; }

        /// <summary>
        /// 学生性别 (0-男,1-女)
        /// </summary>
        public int StuSex { get; set; }

        /// <summary>
        /// 学生出生日期
        /// </summary>
        public DateTime? StuBirth { get; set; }

        /// <summary>
        /// 省份Id
        /// </summary>
        public int ProviceId { get; set; }

        /// <summary>
        /// 城市Id
        /// </summary>
        public int CityId { get; set; }

        /// <summary>
        /// 区县Id
        /// </summary>
        public int AreaId { get; set; }

        /// <summary>
        /// 集团编号
        /// </summary>
        public int Group_Id { get; set; }

        /// <summary>
        /// 学校编号
        /// </summary>
        public int School_Id { get; set; }

        /// <summary>
        /// 删除状态
        /// </summary>
        public DateStateEnum Status { get; set; }

        /// <summary>
        /// 创建人
        /// </summary>
        public int CreateBy { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreateTime { get; set; }

        /// <summary>
        /// 修改人
        /// </summary>
        public int UpdateBy { get; set; }

        /// <summary>
        /// 更新时间
        /// </summary>
        public DateTime UpdateTime { get; set; }

        /// <summary>
        /// 是否禁用(0-禁用,1-启用)
        /// </summary>
        public int IsDisable { get; set; }
    }
}
