﻿using Edu.Common.Enum;
using Edu.Common.Enum.User;
using System;
using VT.FW.DB;

namespace Edu.Model.Entity.User
{
    /// <summary>
    /// 讲师实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Teacher
    {
        /// <summary>
        /// 主键(教师编号)
        /// </summary>
        public int TId { get; set; }

        /// <summary>
        /// 学校Id
        /// </summary>
        public int School_Id { get; set; }

        /// <summary>
        /// 讲师姓名
        /// </summary>
        public string TeacherName { get; set; }

        /// <summary>
        /// 讲师手机号码
        /// </summary>
        public string TeacherTel { get; set; }

        /// <summary>
        /// 讲师头像
        /// </summary>
        public string TeacherHead { get; set; }

        /// <summary>
        /// 讲师形象照
        /// </summary>
        public string TeacherIcon { get; set; }

        /// <summary>
        /// 讲师营销语
        /// </summary>
        public string TeacherSay { get; set; }

        /// <summary>
        /// 讲师介绍
        /// </summary>
        public string TeacherIntro { get; set; }

        /// <summary>
        /// 删除状态
        /// </summary>
        public DateStateEnum Status { get; set; }

        /// <summary>
        /// 审核状态(1-审核中,2-审核通过,3-审核不通过)
        /// </summary>
        public AccountStatusEnum AuditStatus { get; set; }

        /// <summary>
        /// 审核备注
        /// </summary>
        public string AuditRemark { get; set; }

        /// <summary>
        /// 显示状态(1-显示，0-隐藏)
        /// </summary>
        public int IsShow { get; set; }

        /// <summary>
        /// 推荐状态(1-已推荐，0-未推荐)
        /// </summary>
        public int IsRecommend { get; set; }

        /// <summary>
        /// 排序
        /// </summary>
        public int SortNum { get; set; }

        /// <summary>
        /// 创建人
        /// </summary>
        public int CreateBy { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreateTime { get; set; }

        /// <summary>
        /// 修改人
        /// </summary>
        public int UpdateBy { get; set; }

        /// <summary>
        /// 更新时间
        /// </summary>
        public DateTime UpdateTime { get; set; }

        /// <summary>
        /// 集团编号
        /// </summary>
        public int Group_Id { get; set; }
    }
}