﻿using System;

namespace Edu.Model.ViewModel.User
{
    /// <summary>
    /// 助教视图实体类
    /// </summary>
    [Serializable]
    public class RB_Assist_ViewModel : Entity.User.RB_Assist
    {
        /// <summary>
        /// 集团名称
        /// </summary>
        public string GroupName { get; set; }

        /// <summary>
        /// 学校名称
        /// </summary>
        public string SName { get; set; }

        /// <summary>
        /// 创建人
        /// </summary>
        public string CreateByName { get; set; }

        /// <summary>
        /// 创建时间字符串
        /// </summary>
        public string CreateTimeStr { get { return Common.ConvertHelper.FormatTime(this.CreateTime); } }

        /// <summary>
        /// 更新人
        /// </summary>
        public string UpdateByName { get; set; }

        /// <summary>
        /// 更新时间
        /// </summary>
        public string UpdateTimeStr { get { return Common.ConvertHelper.FormatTime(this.UpdateTime); } }

        /// <summary>
        /// 审核状态字符串
        /// </summary>
        public string AuditStatusStr { get { return Common.Plugin.EnumHelper.GetEnumName(this.AuditStatus); } }
    }
}