﻿using System;

namespace Edu.Model.ViewModel.User
{
    /// <summary>
    /// 学生视图实体类
    /// </summary>
    [Serializable]
    public class RB_Student_ViewModel : Model.Entity.User.RB_Student
    {
        /// <summary>
        /// 创建人姓名
        /// </summary>
        public string CreateByName { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public string CreateTimeStr { get { return Common.ConvertHelper.FormatTime(this.CreateTime); } }

        /// <summary>
        /// 修改人姓名
        /// </summary>
        public string UpdateByName { get; set; }

        /// <summary>
        /// 修改时间
        /// </summary>
        public string UpdateTimeStr { get { return Common.ConvertHelper.FormatTime(this.UpdateTime); } }

        /// <summary>
        /// 禁用、启用字符串
        /// </summary>
        public string IsDisableStr
        {
            get
            {
                string str = "启用";
                if (this.IsDisable == 0)
                {
                    str = "禁用";
                }
                return str;
            }
        }
    }
}